/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.jdbc;

import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcPreparedStatement;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcResultSet;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.message.Trace;
import com.alibaba.schedulerx.shade.org.h2.message.TraceObject;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.value.DataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JdbcResultSetMetaData
extends TraceObject
implements ResultSetMetaData {
    private final String catalog;
    private final JdbcResultSet rs;
    private final JdbcPreparedStatement prep;
    private final ResultInterface result;
    private final int columnCount;

    JdbcResultSetMetaData(JdbcResultSet jdbcResultSet, JdbcPreparedStatement jdbcPreparedStatement, ResultInterface resultInterface, String string2, Trace trace, int n) {
        this.setTrace(trace, 5, n);
        this.catalog = string2;
        this.rs = jdbcResultSet;
        this.prep = jdbcPreparedStatement;
        this.result = resultInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            this.debugCodeCall("getColumnCount");
            this.checkClosed();
            return this.columnCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnLabel", n);
            this.checkColumnIndex(n);
            return this.result.getAlias(--n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnName", n);
            this.checkColumnIndex(n);
            return this.result.getColumnName(--n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnType", n);
            this.checkColumnIndex(n);
            int n2 = this.result.getColumnType(--n);
            return DataType.convertTypeToSQLType(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnTypeName", n);
            this.checkColumnIndex(n);
            int n2 = this.result.getColumnType(--n);
            return DataType.getDataType((int)n2).name;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        try {
            this.debugCodeCall("getSchemaName", n);
            this.checkColumnIndex(n);
            String string2 = this.result.getSchemaName(--n);
            return string2 == null ? "" : string2;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getTableName(int n) throws SQLException {
        try {
            this.debugCodeCall("getTableName", n);
            this.checkColumnIndex(n);
            String string2 = this.result.getTableName(--n);
            return string2 == null ? "" : string2;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        try {
            this.debugCodeCall("getCatalogName", n);
            this.checkColumnIndex(n);
            return this.catalog == null ? "" : this.catalog;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        try {
            this.debugCodeCall("isAutoIncrement", n);
            this.checkColumnIndex(n);
            return this.result.isAutoIncrement(--n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        try {
            this.debugCodeCall("isCaseSensitive", n);
            this.checkColumnIndex(n);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        try {
            this.debugCodeCall("isSearchable", n);
            this.checkColumnIndex(n);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        try {
            this.debugCodeCall("isCurrency", n);
            this.checkColumnIndex(n);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int isNullable(int n) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n);
            this.checkColumnIndex(n);
            return this.result.getNullable(--n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n);
            this.checkColumnIndex(n);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        try {
            this.debugCodeCall("isReadOnly", n);
            this.checkColumnIndex(n);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        try {
            this.debugCodeCall("isWritable", n);
            this.checkColumnIndex(n);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        try {
            this.debugCodeCall("isDefinitelyWritable", n);
            this.checkColumnIndex(n);
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnClassName", n);
            this.checkColumnIndex(n);
            int n2 = this.result.getColumnType(--n);
            return DataType.getTypeClassName(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n);
            this.checkColumnIndex(n);
            long l = this.result.getColumnPrecision(--n);
            return MathUtils.convertLongToInt(l);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getScale(int n) throws SQLException {
        try {
            this.debugCodeCall("getScale", n);
            this.checkColumnIndex(n);
            return this.result.getColumnScale(--n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnDisplaySize", n);
            this.checkColumnIndex(n);
            return this.result.getDisplaySize(--n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void checkClosed() {
        if (this.rs != null) {
            this.rs.checkClosed();
        }
        if (this.prep != null) {
            this.prep.checkClosed();
        }
    }

    private void checkColumnIndex(int n) {
        this.checkClosed();
        if (n < 1 || n > this.columnCount) {
            throw DbException.getInvalidValueException("columnIndex", n);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (this.isWrapperFor(clazz)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", clazz);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return this.getTraceObjectName() + ": columns=" + this.columnCount;
    }
}

