/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;

public class JdbcSQLException
extends SQLException {
    public static final String HIDE_SQL = "--hide--";
    private static final long serialVersionUID = 1L;
    private final String originalMessage;
    private final Throwable cause;
    private final String stackTrace;
    private String message;
    private String sql;

    public JdbcSQLException(String string2, String string3, String string4, int n, Throwable throwable, String string5) {
        super(string2, string4, n);
        this.originalMessage = string2;
        this.setSQL(string3);
        this.cause = throwable;
        this.stackTrace = string5;
        this.buildMessage();
        this.initCause(throwable);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (printWriter != null) {
            super.printStackTrace(printWriter);
            SQLException sQLException = this.getNextException();
            for (int n = 0; n < 100 && sQLException != null; sQLException = sQLException.getNextException(), ++n) {
                printWriter.println(sQLException.toString());
            }
            if (sQLException != null) {
                printWriter.println("(truncated)");
            }
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (printStream != null) {
            super.printStackTrace(printStream);
            SQLException sQLException = this.getNextException();
            for (int n = 0; n < 100 && sQLException != null; sQLException = sQLException.getNextException(), ++n) {
                printStream.println(sQLException.toString());
            }
            if (sQLException != null) {
                printStream.println("(truncated)");
            }
        }
    }

    public Throwable getOriginalCause() {
        return this.cause;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String string2) {
        if (string2 != null && string2.contains(HIDE_SQL)) {
            string2 = "-";
        }
        this.sql = string2;
        this.buildMessage();
    }

    private void buildMessage() {
        StringBuilder stringBuilder = new StringBuilder(this.originalMessage == null ? "- " : this.originalMessage);
        if (this.sql != null) {
            stringBuilder.append("; SQL statement:\n").append(this.sql);
        }
        stringBuilder.append(" [").append(this.getErrorCode()).append('-').append(197).append(']');
        this.message = stringBuilder.toString();
    }

    @Override
    public String toString() {
        if (this.stackTrace == null) {
            return super.toString();
        }
        return this.stackTrace;
    }
}

