/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.store;

import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.message.TraceSystem;
import com.alibaba.schedulerx.shade.org.h2.store.FileLock;
import com.alibaba.schedulerx.shade.org.h2.store.FileLockMethod;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FilePath;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class FileLister {
    private FileLister() {
    }

    public static void tryUnlockDatabase(List<String> list, String string2) throws SQLException {
        for (String string3 : list) {
            Object object;
            if (string3.endsWith(".lock.db")) {
                object = new FileLock(new TraceSystem(null), string3, 1000);
                try {
                    ((FileLock)object).lock(FileLockMethod.FILE);
                    ((FileLock)object).unlock();
                    continue;
                }
                catch (DbException dbException) {
                    throw DbException.get(90133, string2).getSQLException();
                }
            }
            if (!string3.endsWith(".mv.db")) continue;
            try {
                object = FilePath.get(string3).open("r");
                Throwable throwable = null;
                try {
                    java.nio.channels.FileLock fileLock = ((FileChannel)object).tryLock(0L, Long.MAX_VALUE, true);
                    fileLock.release();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object == null) continue;
                    if (throwable != null) {
                        try {
                            ((AbstractInterruptibleChannel)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((AbstractInterruptibleChannel)object).close();
                }
            }
            catch (Exception exception) {
                throw DbException.get(90133, exception, string2).getSQLException();
            }
        }
    }

    public static String getDir(String string2) {
        if (string2 == null || string2.equals("")) {
            return ".";
        }
        return FileUtils.toRealPath(string2);
    }

    public static ArrayList<String> getDatabaseFiles(String string2, String string3, boolean bl) {
        ArrayList<String> arrayList = New.arrayList();
        String string4 = string3 == null ? null : FileUtils.toRealPath(string2 + "/" + string3) + ".";
        for (String string5 : FileUtils.newDirectoryStream(string2)) {
            boolean bl2 = false;
            if (string5.endsWith(".lobs.db")) {
                if (string4 == null || string5.startsWith(string4)) {
                    arrayList.addAll(FileLister.getDatabaseFiles(string5, null, bl));
                    bl2 = true;
                }
            } else if (string5.endsWith(".lob.db")) {
                bl2 = true;
            } else if (string5.endsWith(".h2.db")) {
                bl2 = true;
            } else if (string5.endsWith(".mv.db")) {
                bl2 = true;
            } else if (bl) {
                if (string5.endsWith(".lock.db")) {
                    bl2 = true;
                } else if (string5.endsWith(".temp.db")) {
                    bl2 = true;
                } else if (string5.endsWith(".trace.db")) {
                    bl2 = true;
                }
            }
            if (!bl2 || string3 != null && !string5.startsWith(string4)) continue;
            arrayList.add(string5);
        }
        return arrayList;
    }
}

