/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.store.fs;

import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileChannelInputStream;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FilePath;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FilePathDisk;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileZip;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FilePathZip
extends FilePath {
    @Override
    public FilePathZip getPath(String string2) {
        FilePathZip filePathZip = new FilePathZip();
        filePathZip.name = string2;
        return filePathZip;
    }

    @Override
    public void createDirectory() {
    }

    @Override
    public boolean createFile() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public void delete() {
        throw DbException.getUnsupportedException("write");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        try {
            String string2 = this.getEntryName();
            if (string2.length() == 0) {
                return true;
            }
            try (ZipFile zipFile = this.openZipFile();){
                boolean bl = zipFile.getEntry(string2) != null;
                return bl;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public FilePath getParent() {
        int n = this.name.lastIndexOf(47);
        return n < 0 ? null : this.getPath(this.name.substring(0, n));
    }

    @Override
    public boolean isAbsolute() {
        String string2 = FilePathZip.translateFileName(this.name);
        return FilePath.get(string2).isAbsolute();
    }

    @Override
    public FilePath unwrap() {
        return FilePath.get(this.name.substring(this.getScheme().length() + 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDirectory() {
        try {
            String string2 = this.getEntryName();
            if (string2.length() == 0) {
                return true;
            }
            try (ZipFile zipFile = this.openZipFile();){
                String string3;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                do {
                    if (!enumeration.hasMoreElements()) return false;
                    ZipEntry zipEntry = enumeration.nextElement();
                    string3 = zipEntry.getName();
                    if (!string3.equals(string2)) continue;
                    boolean bl = zipEntry.isDirectory();
                    return bl;
                } while (!string3.startsWith(string2) || string3.length() != string2.length() + 1 || !string3.equals(string2 + "/"));
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long size() {
        try (ZipFile zipFile = this.openZipFile();){
            ZipEntry zipEntry = zipFile.getEntry(this.getEntryName());
            long l = zipEntry == null ? 0L : zipEntry.getSize();
            return l;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public ArrayList<FilePath> newDirectoryStream() {
        String string2 = this.name;
        ArrayList<FilePath> arrayList = New.arrayList();
        try {
            if (string2.indexOf(33) < 0) {
                string2 = string2 + "!";
            }
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            try (ZipFile zipFile = this.openZipFile();){
                String string3 = this.getEntryName();
                String string4 = string2.substring(0, string2.length() - string3.length());
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    int n;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string5 = zipEntry.getName();
                    if (!string5.startsWith(string3) || string5.length() <= string3.length() || (n = string5.indexOf(47, string3.length())) >= 0 && n < string5.length() - 1) continue;
                    arrayList.add(this.getPath(string4 + string5));
                }
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "listFiles " + string2);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return new FileChannelInputStream(this.open("r"), true);
    }

    @Override
    public FileChannel open(String string2) throws IOException {
        ZipFile zipFile = this.openZipFile();
        ZipEntry zipEntry = zipFile.getEntry(this.getEntryName());
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException(this.name);
        }
        return new FileZip(zipFile, zipEntry);
    }

    @Override
    public OutputStream newOutputStream(boolean bl) throws IOException {
        throw new IOException("write");
    }

    @Override
    public void moveTo(FilePath filePath, boolean bl) {
        throw DbException.getUnsupportedException("write");
    }

    private static String translateFileName(String string2) {
        int n;
        if (string2.startsWith("zip:")) {
            string2 = string2.substring("zip:".length());
        }
        if ((n = string2.indexOf(33)) >= 0) {
            string2 = string2.substring(0, n);
        }
        return FilePathDisk.expandUserHomeDirectory(string2);
    }

    @Override
    public FilePath toRealPath() {
        return this;
    }

    private String getEntryName() {
        int n = this.name.indexOf(33);
        String string2 = n <= 0 ? "" : this.name.substring(n + 1);
        if ((string2 = string2.replace('\\', '/')).startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private ZipFile openZipFile() throws IOException {
        String string2 = FilePathZip.translateFileName(this.name);
        return new ZipFile(string2);
    }

    @Override
    public FilePath createTempFile(String string2, boolean bl, boolean bl2) throws IOException {
        if (!bl2) {
            throw new IOException("File system is read-only");
        }
        return new FilePathDisk().getPath(this.name).createTempFile(string2, bl, true);
    }

    @Override
    public String getScheme() {
        return "zip";
    }
}

