/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.store.fs;

import com.alibaba.schedulerx.shade.org.h2.store.fs.FilePath;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static boolean exists(String string2) {
        return FilePath.get(string2).exists();
    }

    public static void createDirectory(String string2) {
        FilePath.get(string2).createDirectory();
    }

    public static boolean createFile(String string2) {
        return FilePath.get(string2).createFile();
    }

    public static void delete(String string2) {
        FilePath.get(string2).delete();
    }

    public static String toRealPath(String string2) {
        return FilePath.get(string2).toRealPath().toString();
    }

    public static String getParent(String string2) {
        FilePath filePath = FilePath.get(string2).getParent();
        return filePath == null ? null : filePath.toString();
    }

    public static boolean isAbsolute(String string2) {
        return FilePath.get(string2).isAbsolute() || string2.startsWith("/");
    }

    public static void move(String string2, String string3) {
        FilePath.get(string2).moveTo(FilePath.get(string3), false);
    }

    public static void moveAtomicReplace(String string2, String string3) {
        FilePath.get(string2).moveTo(FilePath.get(string3), true);
    }

    public static String getName(String string2) {
        return FilePath.get(string2).getName();
    }

    public static List<String> newDirectoryStream(String string2) {
        List<FilePath> list = FilePath.get(string2).newDirectoryStream();
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (FilePath filePath : list) {
            arrayList.add(filePath.toString());
        }
        return arrayList;
    }

    public static long lastModified(String string2) {
        return FilePath.get(string2).lastModified();
    }

    public static long size(String string2) {
        return FilePath.get(string2).size();
    }

    public static boolean isDirectory(String string2) {
        return FilePath.get(string2).isDirectory();
    }

    public static FileChannel open(String string2, String string3) throws IOException {
        return FilePath.get(string2).open(string3);
    }

    public static InputStream newInputStream(String string2) throws IOException {
        return FilePath.get(string2).newInputStream();
    }

    public static OutputStream newOutputStream(String string2, boolean bl) throws IOException {
        return FilePath.get(string2).newOutputStream(bl);
    }

    public static boolean canWrite(String string2) {
        return FilePath.get(string2).canWrite();
    }

    public static boolean setReadOnly(String string2) {
        return FilePath.get(string2).setReadOnly();
    }

    public static String unwrap(String string2) {
        return FilePath.get(string2).unwrap().toString();
    }

    public static void deleteRecursive(String string2, boolean bl) {
        if (FileUtils.exists(string2)) {
            if (FileUtils.isDirectory(string2)) {
                for (String string3 : FileUtils.newDirectoryStream(string2)) {
                    FileUtils.deleteRecursive(string3, bl);
                }
            }
            if (bl) {
                FileUtils.tryDelete(string2);
            } else {
                FileUtils.delete(string2);
            }
        }
    }

    public static void createDirectories(String string2) {
        if (string2 != null) {
            if (FileUtils.exists(string2)) {
                if (!FileUtils.isDirectory(string2)) {
                    FileUtils.createDirectory(string2);
                }
            } else {
                String string3 = FileUtils.getParent(string2);
                FileUtils.createDirectories(string3);
                FileUtils.createDirectory(string2);
            }
        }
    }

    public static boolean tryDelete(String string2) {
        try {
            FilePath.get(string2).delete();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String createTempFile(String string2, String string3, boolean bl, boolean bl2) throws IOException {
        return FilePath.get(string2).createTempFile(string3, bl, bl2).toString();
    }

    public static void readFully(FileChannel fileChannel, ByteBuffer byteBuffer) throws IOException {
        do {
            int n;
            if ((n = fileChannel.read(byteBuffer)) >= 0) continue;
            throw new EOFException();
        } while (byteBuffer.remaining() > 0);
    }

    public static void writeFully(FileChannel fileChannel, ByteBuffer byteBuffer) throws IOException {
        do {
            fileChannel.write(byteBuffer);
        } while (byteBuffer.remaining() > 0);
    }
}

