/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.table;

import com.alibaba.schedulerx.shade.org.h2.command.Parser;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Select;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.expression.ConditionAndOr;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.index.IndexCondition;
import com.alibaba.schedulerx.shade.org.h2.index.IndexCursor;
import com.alibaba.schedulerx.shade.org.h2.index.IndexLookupBatch;
import com.alibaba.schedulerx.shade.org.h2.index.ViewIndex;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.result.SearchRow;
import com.alibaba.schedulerx.shade.org.h2.result.SortOrder;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.ColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.table.IndexHints;
import com.alibaba.schedulerx.shade.org.h2.table.JoinBatch;
import com.alibaba.schedulerx.shade.org.h2.table.PlanItem;
import com.alibaba.schedulerx.shade.org.h2.table.SubQueryInfo;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableView;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueLong;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TableFilter
implements ColumnResolver {
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    protected boolean joinOuterIndirect;
    private Session session;
    private final Table table;
    private final Select select;
    private String alias;
    private Index index;
    private final IndexHints indexHints;
    private int[] masks;
    private int scanCount;
    private boolean evaluatable;
    private JoinBatch joinBatch;
    private int joinFilterId = -1;
    private boolean used;
    private final IndexCursor cursor;
    private final ArrayList<IndexCondition> indexConditions = New.arrayList();
    private Expression filterCondition;
    private Expression joinCondition;
    private SearchRow currentSearchRow;
    private Row current;
    private int state;
    private TableFilter join;
    private boolean joinOuter;
    private TableFilter nestedJoin;
    private ArrayList<Column> naturalJoinColumns;
    private boolean foundOne;
    private Expression fullCondition;
    private final int hashCode;
    private final int orderInFrom;
    private HashMap<Column, String> derivedColumnMap;

    public TableFilter(Session session, Table table, String string2, boolean bl, Select select, int n, IndexHints indexHints) {
        this.session = session;
        this.table = table;
        this.alias = string2;
        this.select = select;
        this.cursor = new IndexCursor(this);
        if (!bl) {
            session.getUser().checkRight(table, 1);
        }
        this.hashCode = session.nextObjectId();
        this.orderInFrom = n;
        this.indexHints = indexHints;
    }

    public int getOrderInFrom() {
        return this.orderInFrom;
    }

    public IndexCursor getIndexCursor() {
        return this.cursor;
    }

    @Override
    public Select getSelect() {
        return this.select;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(Session session, boolean bl, boolean bl2) {
        this.table.lock(session, bl, bl2);
        if (this.join != null) {
            this.join.lock(session, bl, bl2);
        }
    }

    public PlanItem getBestPlanItem(Session session, TableFilter[] tableFilterArray, int n, HashSet<Column> hashSet) {
        PlanItem planItem = null;
        SortOrder sortOrder = null;
        if (this.select != null) {
            sortOrder = this.select.getSortOrder();
        }
        if (this.indexConditions.isEmpty()) {
            planItem = new PlanItem();
            planItem.setIndex(this.table.getScanIndex(session, null, tableFilterArray, n, sortOrder, hashSet));
            planItem.cost = planItem.getIndex().getCost(session, null, tableFilterArray, n, sortOrder, hashSet);
        }
        int n2 = this.table.getColumns().length;
        int[] nArray = new int[n2];
        for (IndexCondition indexCondition : this.indexConditions) {
            if (!indexCondition.isEvaluatable()) continue;
            if (indexCondition.isAlwaysFalse()) {
                nArray = null;
                break;
            }
            int n3 = indexCondition.getColumn().getColumnId();
            if (n3 < 0) continue;
            int n4 = n3;
            nArray[n4] = nArray[n4] | indexCondition.getMask(this.indexConditions);
        }
        Object object = this.table.getBestPlanItem(session, nArray, tableFilterArray, n, sortOrder, hashSet);
        ((PlanItem)object).setMasks(nArray);
        ((PlanItem)object).cost -= ((PlanItem)object).cost * (double)this.indexConditions.size() / 100.0 / (double)(n + 1);
        if (planItem != null && planItem.cost < ((PlanItem)object).cost) {
            object = planItem;
        }
        if (this.nestedJoin != null) {
            this.setEvaluatable(true);
            ((PlanItem)object).setNestedJoinPlan(this.nestedJoin.getBestPlanItem(session, tableFilterArray, n, hashSet));
            ((PlanItem)object).cost += ((PlanItem)object).cost * ((PlanItem)object).getNestedJoinPlan().cost;
        }
        if (this.join != null) {
            this.setEvaluatable(true);
            while (tableFilterArray[++n] != this.join) {
            }
            ((PlanItem)object).setJoinPlan(this.join.getBestPlanItem(session, tableFilterArray, n, hashSet));
            ((PlanItem)object).cost += ((PlanItem)object).cost * ((PlanItem)object).getJoinPlan().cost;
        }
        return object;
    }

    public void setPlanItem(PlanItem planItem) {
        if (planItem == null) {
            return;
        }
        this.setIndex(planItem.getIndex());
        this.masks = planItem.getMasks();
        if (this.nestedJoin != null) {
            if (planItem.getNestedJoinPlan() != null) {
                this.nestedJoin.setPlanItem(planItem.getNestedJoinPlan());
            } else {
                this.nestedJoin.setScanIndexes();
            }
        }
        if (this.join != null) {
            if (planItem.getJoinPlan() != null) {
                this.join.setPlanItem(planItem.getJoinPlan());
            } else {
                this.join.setScanIndexes();
            }
        }
    }

    private void setScanIndexes() {
        if (this.index == null) {
            this.setIndex(this.table.getScanIndex(this.session));
        }
        if (this.join != null) {
            this.join.setScanIndexes();
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.setScanIndexes();
        }
    }

    public void prepare() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            Column column;
            IndexCondition indexCondition = this.indexConditions.get(i);
            if (indexCondition.isAlwaysFalse() || (column = indexCondition.getColumn()).getColumnId() < 0 || this.index.getColumnIndex(column) >= 0) continue;
            this.indexConditions.remove(i);
            --i;
        }
        if (this.nestedJoin != null) {
            if (SysProperties.CHECK && this.nestedJoin == this) {
                DbException.throwInternalError("self join");
            }
            this.nestedJoin.prepare();
        }
        if (this.join != null) {
            if (SysProperties.CHECK && this.join == this) {
                DbException.throwInternalError("self join");
            }
            this.join.prepare();
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(this.session);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimize(this.session);
        }
    }

    public void startQuery(Session session) {
        this.session = session;
        this.scanCount = 0;
        if (this.nestedJoin != null) {
            this.nestedJoin.startQuery(session);
        }
        if (this.join != null) {
            this.join.startQuery(session);
        }
    }

    public void reset() {
        if (this.joinBatch != null && this.joinFilterId == 0) {
            this.joinBatch.reset(true);
            return;
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.reset();
        }
        if (this.join != null) {
            this.join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    private boolean isAlwaysTopTableFilter(int n) {
        if (n != 0) {
            return false;
        }
        SubQueryInfo subQueryInfo = this.session.getSubQueryInfo();
        while (subQueryInfo != null) {
            if (subQueryInfo.getFilter() != 0) {
                return false;
            }
            subQueryInfo = subQueryInfo.getUpper();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinBatch prepareJoinBatch(JoinBatch joinBatch, TableFilter[] tableFilterArray, int n) {
        assert (tableFilterArray[n] == this);
        this.joinBatch = null;
        this.joinFilterId = -1;
        if (this.getTable().isView()) {
            this.session.pushSubQueryInfo(this.masks, tableFilterArray, n, this.select.getSortOrder());
            try {
                ((ViewIndex)this.index).getQuery().prepareJoinBatch();
            }
            finally {
                this.session.popSubQueryInfo();
            }
        }
        IndexLookupBatch indexLookupBatch = null;
        if (joinBatch == null && this.select != null && !this.isAlwaysTopTableFilter(n) && (indexLookupBatch = this.index.createLookupBatch(tableFilterArray, n)) != null) {
            joinBatch = new JoinBatch(n + 1, this.join);
        }
        if (joinBatch != null) {
            if (this.nestedJoin != null) {
                throw DbException.throwInternalError();
            }
            this.joinBatch = joinBatch;
            this.joinFilterId = n;
            if (indexLookupBatch == null && !this.isAlwaysTopTableFilter(n) && (indexLookupBatch = this.index.createLookupBatch(tableFilterArray, n)) == null) {
                indexLookupBatch = JoinBatch.createFakeIndexLookupBatch(this);
            }
            joinBatch.register(this, indexLookupBatch);
        }
        return joinBatch;
    }

    public int getJoinFilterId() {
        return this.joinFilterId;
    }

    public JoinBatch getJoinBatch() {
        return this.joinBatch;
    }

    public boolean next() {
        if (this.joinBatch != null) {
            return this.joinBatch.next();
        }
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            this.cursor.find(this.session, this.indexConditions);
            if (!this.cursor.isAlwaysFalse()) {
                if (this.nestedJoin != null) {
                    this.nestedJoin.reset();
                }
                if (this.join != null) {
                    this.join.reset();
                }
            }
        } else if (this.join != null && this.join.next()) {
            return true;
        }
        while (this.state != 3) {
            if (this.cursor.isAlwaysFalse()) {
                this.state = 2;
            } else if (this.nestedJoin != null) {
                if (this.state == 0) {
                    this.state = 1;
                }
            } else {
                if ((++this.scanCount & 0xFFF) == 0) {
                    this.checkTimeout();
                }
                if (this.cursor.next()) {
                    this.currentSearchRow = this.cursor.getSearchRow();
                    this.current = null;
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.nestedJoin != null && this.state == 1 && !this.nestedJoin.next()) {
                this.state = 2;
                if (!this.joinOuter || this.foundOne) continue;
            }
            if (this.state == 2) {
                if (!this.joinOuter || this.foundOne) break;
                this.setNullRow();
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean bl = this.isOk(this.joinCondition);
            if (this.state == 1) {
                if (!bl) continue;
                this.foundOne = true;
            }
            if (this.join != null) {
                this.join.reset();
                if (!this.join.next()) continue;
            }
            if (this.state != 3 && !bl) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    protected void setNullRow() {
        this.state = 3;
        this.current = this.table.getNullRow();
        this.currentSearchRow = this.current;
        if (this.nestedJoin != null) {
            this.nestedJoin.visit(new TableFilterVisitor(){

                @Override
                public void accept(TableFilter tableFilter) {
                    tableFilter.setNullRow();
                }
            });
        }
    }

    private void checkTimeout() {
        this.session.checkCanceled();
    }

    boolean isOk(Expression expression) {
        return expression == null || expression.getBooleanValue(this.session);
    }

    public Row get() {
        if (this.current == null && this.currentSearchRow != null) {
            this.current = this.cursor.get();
        }
        return this.current;
    }

    public void set(Row row) {
        this.current = row;
        this.currentSearchRow = row;
    }

    @Override
    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition indexCondition) {
        this.indexConditions.add(indexCondition);
    }

    public void addFilterCondition(Expression expression, boolean bl) {
        if (bl) {
            this.joinCondition = this.joinCondition == null ? expression : new ConditionAndOr(0, this.joinCondition, expression);
        } else {
            this.filterCondition = this.filterCondition == null ? expression : new ConditionAndOr(0, this.filterCondition, expression);
        }
    }

    public void addJoin(TableFilter tableFilter, boolean bl, Expression expression) {
        if (expression != null) {
            expression.mapColumns(this, 0);
            MapColumnsVisitor mapColumnsVisitor = new MapColumnsVisitor(expression);
            this.visit(mapColumnsVisitor);
            tableFilter.visit(mapColumnsVisitor);
        }
        if (this.join == null) {
            this.join = tableFilter;
            tableFilter.joinOuter = bl;
            if (bl) {
                tableFilter.visit(new JOIVisitor());
            }
            if (expression != null) {
                tableFilter.mapAndAddFilter(expression);
            }
        } else {
            this.join.addJoin(tableFilter, bl, expression);
        }
    }

    public void setNestedJoin(TableFilter tableFilter) {
        this.nestedJoin = tableFilter;
    }

    public void mapAndAddFilter(Expression expression) {
        expression.mapColumns(this, 0);
        this.addFilterCondition(expression, true);
        expression.createIndexConditions(this.session, this);
        if (this.nestedJoin != null) {
            expression.mapColumns(this.nestedJoin, 0);
            expression.createIndexConditions(this.session, this.nestedJoin);
        }
        if (this.join != null) {
            this.join.mapAndAddFilter(expression);
        }
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public boolean isJoinOuter() {
        return this.joinOuter;
    }

    public boolean isJoinOuterIndirect() {
        return this.joinOuterIndirect;
    }

    public String getPlanSQL(boolean bl) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            if (this.joinOuter) {
                stringBuilder.append("LEFT OUTER JOIN ");
            } else {
                stringBuilder.append("INNER JOIN ");
            }
        }
        if (this.nestedJoin != null) {
            boolean bl2;
            StringBuilder stringBuilder2 = new StringBuilder();
            TableFilter tableFilter = this.nestedJoin;
            do {
                stringBuilder2.append(tableFilter.getPlanSQL(tableFilter != this.nestedJoin));
                stringBuilder2.append('\n');
            } while ((tableFilter = tableFilter.getJoin()) != null);
            String string2 = stringBuilder2.toString();
            boolean bl3 = bl2 = !string2.startsWith("(");
            if (bl2) {
                stringBuilder.append("(\n");
            }
            stringBuilder.append(StringUtils.indent(string2, 4, false));
            if (bl2) {
                stringBuilder.append(')');
            }
            if (bl) {
                stringBuilder.append(" ON ");
                if (this.joinCondition == null) {
                    stringBuilder.append("1=1");
                } else {
                    stringBuilder.append(StringUtils.unEnclose(this.joinCondition.getSQL()));
                }
            }
            return stringBuilder.toString();
        }
        if (this.table.isView() && ((TableView)this.table).isRecursive()) {
            stringBuilder.append(this.table.getName());
        } else {
            stringBuilder.append(this.table.getSQL());
        }
        if (this.table.isView() && ((TableView)this.table).isInvalid()) {
            throw DbException.get(90109, this.table.getName(), "not compiled");
        }
        if (this.alias != null) {
            stringBuilder.append(' ').append(Parser.quoteIdentifier(this.alias));
        }
        if (this.indexHints != null) {
            stringBuilder.append(" USE INDEX (");
            boolean bl4 = true;
            object2 = this.indexHints.getAllowedIndexes().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!bl4) {
                    stringBuilder.append(", ");
                } else {
                    bl4 = false;
                }
                stringBuilder.append(Parser.quoteIdentifier((String)object));
            }
            stringBuilder.append(")");
        }
        if (this.index != null) {
            stringBuilder.append('\n');
            StatementBuilder statementBuilder = new StatementBuilder();
            if (this.joinBatch != null) {
                object2 = this.joinBatch.getLookupBatch(this.joinFilterId);
                if (object2 == null) {
                    if (this.joinFilterId != 0) {
                        throw DbException.throwInternalError("" + this.joinFilterId);
                    }
                } else {
                    statementBuilder.append("batched:");
                    object = object2.getPlanSQL();
                    statementBuilder.append((String)object);
                    statementBuilder.append(" ");
                }
            }
            statementBuilder.append(this.index.getPlanSQL());
            if (!this.indexConditions.isEmpty()) {
                statementBuilder.append(": ");
                object2 = this.indexConditions.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    statementBuilder.appendExceptFirst("\n    AND ");
                    statementBuilder.append(((IndexCondition)object).getSQL());
                }
            }
            if (((String)(object2 = StringUtils.quoteRemarkSQL(statementBuilder.toString()))).indexOf(10) >= 0) {
                object2 = object2 + "\n";
            }
            stringBuilder.append(StringUtils.indent("/* " + object2 + " */", 4, false));
        }
        if (bl) {
            stringBuilder.append("\n    ON ");
            if (this.joinCondition == null) {
                stringBuilder.append("1=1");
            } else {
                stringBuilder.append(StringUtils.unEnclose(this.joinCondition.getSQL()));
            }
        }
        if (this.filterCondition != null) {
            stringBuilder.append('\n');
            String string3 = StringUtils.unEnclose(this.filterCondition.getSQL());
            string3 = "/* WHERE " + StringUtils.quoteRemarkSQL(string3) + "\n*/";
            stringBuilder.append(StringUtils.indent(string3, 4, false));
        }
        if (this.scanCount > 0) {
            stringBuilder.append("\n    /* scanCount: ").append(this.scanCount).append(" */");
        }
        return stringBuilder.toString();
    }

    void removeUnusableIndexConditions() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            IndexCondition indexCondition = this.indexConditions.get(i);
            if (indexCondition.isEvaluatable()) continue;
            this.indexConditions.remove(i--);
        }
    }

    public int[] getMasks() {
        return this.masks;
    }

    public ArrayList<IndexCondition> getIndexConditions() {
        return this.indexConditions;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
        this.cursor.setIndex(index);
    }

    public void setUsed(boolean bl) {
        this.used = bl;
    }

    public boolean isUsed() {
        return this.used;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.join = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression expression) {
        this.fullCondition = expression;
        if (this.join != null) {
            this.join.setFullCondition(expression);
        }
    }

    void optimizeFullCondition(boolean bl) {
        if (this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this, bl || this.joinOuter);
            if (this.nestedJoin != null) {
                this.nestedJoin.optimizeFullCondition(bl || this.joinOuter);
            }
            if (this.join != null) {
                this.join.optimizeFullCondition(bl || this.joinOuter);
            }
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        tableFilter.setEvaluatable(bl);
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, bl);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(tableFilter, bl);
        }
        if (this.nestedJoin != null && this == tableFilter) {
            this.nestedJoin.setEvaluatable(this.nestedJoin, bl);
        }
        if (this.join != null) {
            this.join.setEvaluatable(tableFilter, bl);
        }
    }

    public void setEvaluatable(boolean bl) {
        this.evaluatable = bl;
    }

    @Override
    public String getSchemaName() {
        return this.table.getSchema().getName();
    }

    @Override
    public Column[] getColumns() {
        return this.table.getColumns();
    }

    @Override
    public String getDerivedColumnName(Column column) {
        HashMap<Column, String> hashMap = this.derivedColumnMap;
        return hashMap != null ? hashMap.get(column) : null;
    }

    @Override
    public Column[] getSystemColumns() {
        if (!this.session.getDatabase().getMode().systemColumns) {
            return null;
        }
        Column[] columnArray = new Column[3];
        columnArray[0] = new Column("oid", 4);
        columnArray[0].setTable(this.table, 0);
        columnArray[1] = new Column("ctid", 13);
        columnArray[1].setTable(this.table, 0);
        columnArray[2] = new Column("CTID", 13);
        columnArray[2].setTable(this.table, 0);
        return columnArray;
    }

    @Override
    public Column getRowIdColumn() {
        if (this.session.getDatabase().getSettings().rowId) {
            return this.table.getRowIdColumn();
        }
        return null;
    }

    @Override
    public Value getValue(Column column) {
        if (this.joinBatch != null) {
            return this.joinBatch.getValue(this.joinFilterId, column);
        }
        if (this.currentSearchRow == null) {
            return null;
        }
        int n = column.getColumnId();
        if (n == -1) {
            return ValueLong.get(this.currentSearchRow.getKey());
        }
        if (this.current == null) {
            Value value = this.currentSearchRow.getValue(n);
            if (value != null) {
                return value;
            }
            this.current = this.cursor.get();
            if (this.current == null) {
                return ValueNull.INSTANCE;
            }
        }
        return this.current.getValue(n);
    }

    @Override
    public TableFilter getTableFilter() {
        return this;
    }

    public void setAlias(String string2) {
        this.alias = string2;
    }

    public void setDerivedColumns(ArrayList<String> arrayList) {
        Column[] columnArray = this.getColumns();
        int n = columnArray.length;
        if (n != arrayList.size()) {
            throw DbException.get(21002);
        }
        HashMap<Column, String> hashMap = new HashMap<Column, String>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = arrayList.get(i);
            for (int j = 0; j < i; ++j) {
                if (!string2.equals(arrayList.get(j))) continue;
                throw DbException.get(42121, string2);
            }
            hashMap.put(columnArray[i], string2);
        }
        this.derivedColumnMap = hashMap;
    }

    @Override
    public Expression optimize(ExpressionColumn expressionColumn, Column column) {
        return expressionColumn;
    }

    public String toString() {
        return this.alias != null ? this.alias : this.table.toString();
    }

    public void addNaturalJoinColumn(Column column) {
        if (this.naturalJoinColumns == null) {
            this.naturalJoinColumns = New.arrayList();
        }
        this.naturalJoinColumns.add(column);
    }

    public boolean isNaturalJoinColumn(Column column) {
        return this.naturalJoinColumns != null && this.naturalJoinColumns.contains(column);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean hasInComparisons() {
        for (IndexCondition indexCondition : this.indexConditions) {
            int n = indexCondition.getCompareType();
            if (n != 10 && n != 9) continue;
            return true;
        }
        return false;
    }

    public void lockRowAdd(ArrayList<Row> arrayList) {
        if (this.state == 1) {
            arrayList.add(this.get());
        }
    }

    public void lockRows(ArrayList<Row> arrayList) {
        for (Row row : arrayList) {
            Row row2 = row.getCopy();
            this.table.removeRow(this.session, row);
            this.session.log(this.table, (short)1, row);
            this.table.addRow(this.session, row2);
            this.session.log(this.table, (short)0, row2);
        }
    }

    public TableFilter getNestedJoin() {
        return this.nestedJoin;
    }

    public void visit(TableFilterVisitor tableFilterVisitor) {
        TableFilter tableFilter = this;
        do {
            tableFilterVisitor.accept(tableFilter);
            TableFilter tableFilter2 = tableFilter.nestedJoin;
            if (tableFilter2 == null) continue;
            tableFilter2.visit(tableFilterVisitor);
        } while ((tableFilter = tableFilter.join) != null);
    }

    public boolean isEvaluatable() {
        return this.evaluatable;
    }

    public Session getSession() {
        return this.session;
    }

    public IndexHints getIndexHints() {
        return this.indexHints;
    }

    private static final class JOIVisitor
    implements TableFilterVisitor {
        JOIVisitor() {
        }

        @Override
        public void accept(TableFilter tableFilter) {
            tableFilter.joinOuterIndirect = true;
        }
    }

    private static final class MapColumnsVisitor
    implements TableFilterVisitor {
        private final Expression on;

        MapColumnsVisitor(Expression expression) {
            this.on = expression;
        }

        @Override
        public void accept(TableFilter tableFilter) {
            this.on.mapColumns(tableFilter, 0);
        }
    }

    public static interface TableFilterVisitor {
        public void accept(TableFilter var1);
    }
}

