/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.util;

import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class StringUtils {
    private static SoftReference<String[]> softCache;
    private static long softCacheCreatedNs;
    private static final char[] HEX;
    private static final int[] HEX_DECODE;
    private static final int TO_UPPER_CACHE_LENGTH = 2048;
    private static final int TO_UPPER_CACHE_MAX_ENTRY_LENGTH = 64;
    private static final String[][] TO_UPPER_CACHE;

    private StringUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCache() {
        String[] stringArray;
        if (softCache != null && (stringArray = softCache.get()) != null) {
            return stringArray;
        }
        long l = System.nanoTime();
        if (softCacheCreatedNs != 0L && l - softCacheCreatedNs < TimeUnit.SECONDS.toNanos(5L)) {
            return null;
        }
        try {
            stringArray = new String[SysProperties.OBJECT_CACHE_SIZE];
            softCache = new SoftReference<String[]>(stringArray);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            softCacheCreatedNs = System.nanoTime();
        }
    }

    public static String toUpperEnglish(String string2) {
        if (string2.length() > 64) {
            return string2.toUpperCase(Locale.ENGLISH);
        }
        int n = string2.hashCode() & 0x7FF;
        String[] stringArray = TO_UPPER_CACHE[n];
        if (stringArray != null && stringArray[0].equals(string2)) {
            return stringArray[1];
        }
        String string3 = string2.toUpperCase(Locale.ENGLISH);
        stringArray = new String[]{string2, string3};
        StringUtils.TO_UPPER_CACHE[n] = stringArray;
        return string3;
    }

    public static String toLowerEnglish(String string2) {
        return string2.toLowerCase(Locale.ENGLISH);
    }

    public static boolean startsWithIgnoreCase(String string2, String string3) {
        if (string2.length() < string3.length()) {
            return false;
        }
        return string2.substring(0, string3.length()).equalsIgnoreCase(string3);
    }

    public static String quoteStringSQL(String string2) {
        if (string2 == null) {
            return "NULL";
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        stringBuilder.append('\'');
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\'') {
                stringBuilder.append(c);
            } else if (c < ' ' || c > '\u007f') {
                return "STRINGDECODE(" + StringUtils.quoteStringSQL(StringUtils.javaEncode(string2)) + ")";
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    public static String javaEncode(String string2) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block8: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                default: {
                    int n2 = c & 0xFFFF;
                    if (n2 >= 32 && n2 < 128) {
                        stringBuilder.append(c);
                        continue block8;
                    }
                    stringBuilder.append("\\u");
                    String string3 = Integer.toHexString(n2);
                    for (int j = string3.length(); j < 4; ++j) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string3);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String addAsterisk(String string2, int n) {
        if (string2 != null) {
            n = Math.min(n, string2.length());
            string2 = string2.substring(0, n) + "[*]" + string2.substring(n);
        }
        return string2;
    }

    private static DbException getFormatException(String string2, int n) {
        return DbException.get(90095, StringUtils.addAsterisk(string2, n));
    }

    public static String javaDecode(String string2) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block17: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\\') {
                if (i + 1 >= string2.length()) {
                    throw StringUtils.getFormatException(string2, i);
                }
                c = string2.charAt(++i);
                switch (c) {
                    case 't': {
                        stringBuilder.append('\t');
                        continue block17;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        continue block17;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        continue block17;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        continue block17;
                    }
                    case '#': {
                        stringBuilder.append('#');
                        continue block17;
                    }
                    case '=': {
                        stringBuilder.append('=');
                        continue block17;
                    }
                    case ':': {
                        stringBuilder.append(':');
                        continue block17;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        continue block17;
                    }
                    case 'u': {
                        try {
                            c = (char)Integer.parseInt(string2.substring(i + 1, i + 5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw StringUtils.getFormatException(string2, i);
                        }
                        i += 4;
                        stringBuilder.append(c);
                        continue block17;
                    }
                    default: {
                        if (c >= '0' && c <= '9') {
                            try {
                                c = (char)Integer.parseInt(string2.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw StringUtils.getFormatException(string2, i);
                            }
                            i += 2;
                            stringBuilder.append(c);
                            continue block17;
                        }
                        throw StringUtils.getFormatException(string2, i);
                    }
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String quoteJavaString(String string2) {
        if (string2 == null) {
            return "null";
        }
        return "\"" + StringUtils.javaEncode(string2) + "\"";
    }

    public static String quoteJavaStringArray(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new String[]{");
        for (String string2 : stringArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(StringUtils.quoteJavaString(string2));
        }
        return statementBuilder.append('}').toString();
    }

    public static String quoteJavaIntArray(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new int[]{");
        for (int n : nArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(n);
        }
        return statementBuilder.append('}').toString();
    }

    public static String enclose(String string2) {
        if (string2.startsWith("(")) {
            return string2;
        }
        return "(" + string2 + ")";
    }

    public static String unEnclose(String string2) {
        if (string2.startsWith("(") && string2.endsWith(")")) {
            return string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    public static String urlEncode(String string2) {
        try {
            return URLEncoder.encode(string2, "UTF-8");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static String urlDecode(String string2) {
        int n = string2.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '+') {
                byArray[n2++] = 32;
                continue;
            }
            if (c == '%') {
                byArray[n2++] = (byte)Integer.parseInt(string2.substring(i + 1, i + 3), 16);
                i += 2;
                continue;
            }
            if (SysProperties.CHECK && (c > '\u007f' || c < ' ')) {
                throw new IllegalArgumentException("Unexpected char " + c + " decoding " + string2);
            }
            byArray[n2++] = (byte)c;
        }
        return new String(byArray, 0, n2, StandardCharsets.UTF_8);
    }

    public static String[] arraySplit(String string2, char c, boolean bl) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        if (n == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = New.arrayList();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c2 = string2.charAt(i);
            if (c2 == c) {
                String string3 = stringBuilder.toString();
                arrayList.add(bl ? string3.trim() : string3);
                stringBuilder.setLength(0);
                continue;
            }
            if (c2 == '\\' && i < n - 1) {
                stringBuilder.append(string2.charAt(++i));
                continue;
            }
            stringBuilder.append(c2);
        }
        String string4 = stringBuilder.toString();
        arrayList.add(bl ? string4.trim() : string4);
        return arrayList.toArray(new String[0]);
    }

    public static String arrayCombine(String[] stringArray, char c) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (String string2 : stringArray) {
            statementBuilder.appendExceptFirst(String.valueOf(c));
            if (string2 == null) {
                string2 = "";
            }
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c2 = string2.charAt(i);
                if (c2 == '\\' || c2 == c) {
                    statementBuilder.append('\\');
                }
                statementBuilder.append(c2);
            }
        }
        return statementBuilder.toString();
    }

    public static String xmlAttr(String string2, String string3) {
        return " " + string2 + "=\"" + StringUtils.xmlText(string3) + "\"";
    }

    public static String xmlNode(String string2, String string3, String string4) {
        return StringUtils.xmlNode(string2, string3, string4, true);
    }

    public static String xmlNode(String string2, String string3, String string4, boolean bl) {
        String string5;
        String string6 = string5 = string3 == null ? string2 : string2 + string3;
        if (string4 == null) {
            return "<" + string5 + "/>\n";
        }
        if (bl && string4.indexOf(10) >= 0) {
            string4 = "\n" + StringUtils.indent(string4);
        }
        return "<" + string5 + ">" + string4 + "</" + string2 + ">\n";
    }

    public static String indent(String string2) {
        return StringUtils.indent(string2, 4, true);
    }

    public static String indent(String string2, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string2.length() + n);
        int n2 = 0;
        while (n2 < string2.length()) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                stringBuilder.append(' ');
            }
            n3 = string2.indexOf(10, n2);
            n3 = n3 < 0 ? string2.length() : n3 + 1;
            stringBuilder.append(string2, n2, n3);
            n2 = n3;
        }
        if (bl && !string2.endsWith("\n")) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String xmlComment(String string2) {
        int n = 0;
        while ((n = string2.indexOf("--", n)) >= 0) {
            string2 = string2.substring(0, n + 1) + " " + string2.substring(n + 1);
        }
        if (string2.indexOf(10) >= 0) {
            return "<!--\n" + StringUtils.indent(string2) + "-->\n";
        }
        return "<!-- " + string2 + " -->\n";
    }

    public static String xmlCData(String string2) {
        if (string2.contains("]]>")) {
            return StringUtils.xmlText(string2);
        }
        boolean bl = string2.endsWith("\n");
        string2 = "<![CDATA[" + string2 + "]]>";
        return bl ? string2 + "\n" : string2;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String string2) {
        return StringUtils.xmlText(string2, false);
    }

    public static String xmlText(String string2, boolean bl) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block9: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (bl) {
                        stringBuilder.append("&#x").append(Integer.toHexString(c)).append(';');
                        continue block9;
                    }
                    stringBuilder.append(c);
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append(c);
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        stringBuilder.append("&#x").append(Integer.toHexString(c)).append(';');
                        continue block9;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String replaceAll(String string2, String string3, String string4) {
        int n = string2.indexOf(string3);
        if (n < 0 || string3.isEmpty()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() - string3.length() + string4.length());
        int n2 = 0;
        do {
            stringBuilder.append(string2, n2, n).append(string4);
        } while ((n = string2.indexOf(string3, n2 = n + string3.length())) >= 0);
        stringBuilder.append(string2, n2, string2.length());
        return stringBuilder.toString();
    }

    public static String quoteIdentifier(String string2) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        stringBuilder.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\"') {
                stringBuilder.append(c);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.append('\"').toString();
    }

    public static boolean isNullOrEmpty(String string2) {
        return string2 == null || string2.length() == 0;
    }

    public static String quoteRemarkSQL(String string2) {
        string2 = StringUtils.replaceAll(string2, "*/", "++/");
        return StringUtils.replaceAll(string2, "/*", "/++");
    }

    public static String pad(String string2, int n, String string3, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n < string2.length()) {
            return string2.substring(0, n);
        }
        if (n == string2.length()) {
            return string2;
        }
        char c = string3 == null || string3.length() == 0 ? (char)' ' : (char)string3.charAt(0);
        StringBuilder stringBuilder = new StringBuilder(n);
        n -= string2.length();
        if (bl) {
            stringBuilder.append(string2);
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        if (!bl) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static char[] cloneCharArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        if (n == 0) {
            return cArray;
        }
        return Arrays.copyOf(cArray, n);
    }

    public static String trim(String string2, boolean bl, boolean bl2, String string3) {
        int n;
        char c = string3 == null || string3.isEmpty() ? (char)' ' : (char)string3.charAt(0);
        int n2 = string2.length();
        if (bl) {
            for (n = 0; n < n2 && string2.charAt(n) == c; ++n) {
            }
        }
        if (bl2) {
            while (n2 > n && string2.charAt(n2 - 1) == c) {
                --n2;
            }
        }
        return string2.substring(n, n2);
    }

    public static String cache(String string2) {
        if (!SysProperties.OBJECT_CACHE) {
            return string2;
        }
        if (string2 == null) {
            return string2;
        }
        if (string2.length() == 0) {
            return "";
        }
        int n = string2.hashCode();
        String[] stringArray = StringUtils.getCache();
        if (stringArray != null) {
            int n2 = n & SysProperties.OBJECT_CACHE_SIZE - 1;
            String string3 = stringArray[n2];
            if (string3 != null && string2.equals(string3)) {
                return string3;
            }
            stringArray[n2] = string2;
        }
        return string2;
    }

    public static void clearCache() {
        softCache = new SoftReference<Object>(null);
    }

    public static byte[] convertHexToBytes(String string2) {
        int n = string2.length();
        if (n % 2 != 0) {
            throw DbException.get(90003, string2);
        }
        byte[] byArray = new byte[n /= 2];
        int n2 = 0;
        int[] nArray = HEX_DECODE;
        try {
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[string2.charAt(i + i)] << 4 | nArray[string2.charAt(i + i + 1)];
                n2 |= n3;
                byArray[i] = (byte)n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw DbException.get(90004, string2);
        }
        if ((n2 & 0xFFFFFF00) != 0) {
            throw DbException.get(90004, string2);
        }
        return byArray;
    }

    public static String convertBytesToHex(byte[] byArray) {
        return StringUtils.convertBytesToHex(byArray, byArray.length);
    }

    public static String convertBytesToHex(byte[] byArray, int n) {
        char[] cArray = new char[n + n];
        char[] cArray2 = HEX;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[i + i] = cArray2[n2 >> 4];
            cArray[i + i + 1] = cArray2[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static boolean isNumber(String string2) {
        if (string2.length() == 0) {
            return false;
        }
        for (char c : string2.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static void appendZeroPadded(StringBuilder stringBuilder, int n, long l) {
        if (n == 2) {
            if (l < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l);
        } else {
            String string2 = Long.toString(l);
            n -= string2.length();
            while (n > 0) {
                stringBuilder.append('0');
                --n;
            }
            stringBuilder.append(string2);
        }
    }

    public static String escapeMetaDataPattern(String string2) {
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        return StringUtils.replaceAll(string2, "\\", "\\\\");
    }

    static {
        int n;
        softCache = new SoftReference<Object>(null);
        HEX = "0123456789abcdef".toCharArray();
        HEX_DECODE = new int[103];
        TO_UPPER_CACHE = new String[2048][];
        for (n = 0; n < HEX_DECODE.length; ++n) {
            StringUtils.HEX_DECODE[n] = -1;
        }
        for (n = 0; n <= 9; ++n) {
            StringUtils.HEX_DECODE[n + 48] = n;
        }
        for (n = 0; n <= 5; ++n) {
            int n2 = n + 10;
            StringUtils.HEX_DECODE[n + 65] = n2;
            StringUtils.HEX_DECODE[n + 97] = n2;
        }
    }
}

