/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.value;

import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.SmallLRUCache;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import java.text.CollationKey;
import java.text.Collator;

public class CompareModeDefault
extends CompareMode {
    private final Collator collator;
    private final SmallLRUCache<String, CollationKey> collationKeys;

    protected CompareModeDefault(String string2, int n, boolean bl) {
        super(string2, n, bl);
        this.collator = CompareMode.getCollator(string2);
        if (this.collator == null) {
            throw DbException.throwInternalError(string2);
        }
        this.collator.setStrength(n);
        int n2 = SysProperties.COLLATOR_CACHE_SIZE;
        this.collationKeys = n2 != 0 ? SmallLRUCache.newInstance(n2) : null;
    }

    @Override
    public int compareString(String string2, String string3, boolean bl) {
        int n;
        if (bl) {
            string2 = string2.toUpperCase();
            string3 = string3.toUpperCase();
        }
        if (this.collationKeys != null) {
            CollationKey collationKey = this.getKey(string2);
            CollationKey collationKey2 = this.getKey(string3);
            n = collationKey.compareTo(collationKey2);
        } else {
            n = this.collator.compare(string2, string3);
        }
        return n;
    }

    @Override
    public boolean equalsChars(String string2, int n, String string3, int n2, boolean bl) {
        return this.compareString(string2.substring(n, n + 1), string3.substring(n2, n2 + 1), bl) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollationKey getKey(String string2) {
        SmallLRUCache<String, CollationKey> smallLRUCache = this.collationKeys;
        synchronized (smallLRUCache) {
            CollationKey collationKey = (CollationKey)this.collationKeys.get(string2);
            if (collationKey == null) {
                collationKey = this.collator.getCollationKey(string2);
                this.collationKeys.put(string2, collationKey);
            }
            return collationKey;
        }
    }
}

