/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.value;

import com.alibaba.schedulerx.shade.org.h2.engine.Mode;
import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.DataHandler;
import com.alibaba.schedulerx.shade.org.h2.tools.SimpleResultSet;
import com.alibaba.schedulerx.shade.org.h2.util.Bits;
import com.alibaba.schedulerx.shade.org.h2.util.DateTimeUtils;
import com.alibaba.schedulerx.shade.org.h2.util.JdbcUtils;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import com.alibaba.schedulerx.shade.org.h2.value.DataType;
import com.alibaba.schedulerx.shade.org.h2.value.ValueArray;
import com.alibaba.schedulerx.shade.org.h2.value.ValueBoolean;
import com.alibaba.schedulerx.shade.org.h2.value.ValueByte;
import com.alibaba.schedulerx.shade.org.h2.value.ValueBytes;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDate;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDecimal;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDouble;
import com.alibaba.schedulerx.shade.org.h2.value.ValueEnum;
import com.alibaba.schedulerx.shade.org.h2.value.ValueFloat;
import com.alibaba.schedulerx.shade.org.h2.value.ValueGeometry;
import com.alibaba.schedulerx.shade.org.h2.value.ValueInt;
import com.alibaba.schedulerx.shade.org.h2.value.ValueJavaObject;
import com.alibaba.schedulerx.shade.org.h2.value.ValueLobDb;
import com.alibaba.schedulerx.shade.org.h2.value.ValueLong;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import com.alibaba.schedulerx.shade.org.h2.value.ValueResultSet;
import com.alibaba.schedulerx.shade.org.h2.value.ValueShort;
import com.alibaba.schedulerx.shade.org.h2.value.ValueString;
import com.alibaba.schedulerx.shade.org.h2.value.ValueStringFixed;
import com.alibaba.schedulerx.shade.org.h2.value.ValueStringIgnoreCase;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTime;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTimestamp;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTimestampTimeZone;
import com.alibaba.schedulerx.shade.org.h2.value.ValueUuid;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public abstract class Value {
    public static final int UNKNOWN = -1;
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int DECIMAL = 6;
    public static final int DOUBLE = 7;
    public static final int FLOAT = 8;
    public static final int TIME = 9;
    public static final int DATE = 10;
    public static final int TIMESTAMP = 11;
    public static final int BYTES = 12;
    public static final int STRING = 13;
    public static final int STRING_IGNORECASE = 14;
    public static final int BLOB = 15;
    public static final int CLOB = 16;
    public static final int ARRAY = 17;
    public static final int RESULT_SET = 18;
    public static final int JAVA_OBJECT = 19;
    public static final int UUID = 20;
    public static final int STRING_FIXED = 21;
    public static final int GEOMETRY = 22;
    public static final int TIMESTAMP_TZ = 24;
    public static final int ENUM = 25;
    public static final int TYPE_COUNT = 25;
    private static SoftReference<Value[]> softCache = new SoftReference<Object>(null);
    private static final BigDecimal MAX_LONG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);

    static void rangeCheck(long l, long l2, long l3) {
        if ((l | l2) < 0L || l2 > l3 - l) {
            if (l < 0L || l > l3) {
                throw DbException.getInvalidValueException("offset", l + 1L);
            }
            throw DbException.getInvalidValueException("length", l2);
        }
    }

    public abstract String getSQL();

    public abstract int getType();

    public abstract long getPrecision();

    public abstract int getDisplaySize();

    public int getMemory() {
        return DataType.getDataType((int)this.getType()).memory;
    }

    public abstract String getString();

    public abstract Object getObject();

    public abstract void set(PreparedStatement var1, int var2) throws SQLException;

    protected abstract int compareSecure(Value var1, CompareMode var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static int getOrder(int n) {
        switch (n) {
            case -1: {
                return 1000;
            }
            case 0: {
                return 2000;
            }
            case 13: {
                return 10000;
            }
            case 16: {
                return 11000;
            }
            case 21: {
                return 12000;
            }
            case 14: {
                return 13000;
            }
            case 1: {
                return 20000;
            }
            case 2: {
                return 21000;
            }
            case 3: {
                return 22000;
            }
            case 4: {
                return 23000;
            }
            case 5: {
                return 24000;
            }
            case 6: {
                return 25000;
            }
            case 8: {
                return 26000;
            }
            case 7: {
                return 27000;
            }
            case 9: {
                return 30000;
            }
            case 10: {
                return 31000;
            }
            case 11: {
                return 32000;
            }
            case 24: {
                return 34000;
            }
            case 12: {
                return 40000;
            }
            case 15: {
                return 41000;
            }
            case 19: {
                return 42000;
            }
            case 20: {
                return 43000;
            }
            case 22: {
                return 44000;
            }
            case 17: {
                return 50000;
            }
            case 18: {
                return 51000;
            }
            case 25: {
                return 52000;
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getDataTypeOrder(n);
        }
        throw DbException.throwInternalError("type:" + n);
    }

    public static int getHigherOrder(int n, int n2) {
        int n3;
        if (n == -1 || n2 == -1) {
            if (n == n2) {
                throw DbException.get(50004, "?, ?");
            }
            if (n == 0) {
                throw DbException.get(50004, "NULL, ?");
            }
            if (n2 == 0) {
                throw DbException.get(50004, "?, NULL");
            }
        }
        if (n == n2) {
            return n;
        }
        int n4 = Value.getOrder(n);
        return n4 > (n3 = Value.getOrder(n2)) ? n : n2;
    }

    static Value cache(Value value) {
        if (SysProperties.OBJECT_CACHE) {
            int n;
            Value value2;
            Value[] valueArray;
            int n2 = value.hashCode();
            if (softCache == null) {
                softCache = new SoftReference<Object>(null);
            }
            if ((valueArray = softCache.get()) == null) {
                valueArray = new Value[SysProperties.OBJECT_CACHE_SIZE];
                softCache = new SoftReference<Value[]>(valueArray);
            }
            if ((value2 = valueArray[n = n2 & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && value2.getType() == value.getType() && value.equals(value2)) {
                return value2;
            }
            valueArray[n] = value;
        }
        return value;
    }

    public static void clearCache() {
        softCache = null;
    }

    public boolean getBoolean() {
        return ((ValueBoolean)this.convertTo(1)).getBoolean();
    }

    public Date getDate() {
        return ((ValueDate)this.convertTo(10)).getDate();
    }

    public Time getTime() {
        return ((ValueTime)this.convertTo(9)).getTime();
    }

    public Timestamp getTimestamp() {
        return ((ValueTimestamp)this.convertTo(11)).getTimestamp();
    }

    public byte[] getBytes() {
        return ((ValueBytes)this.convertTo(12)).getBytes();
    }

    public byte[] getBytesNoCopy() {
        return ((ValueBytes)this.convertTo(12)).getBytesNoCopy();
    }

    public byte getByte() {
        return ((ValueByte)this.convertTo(2)).getByte();
    }

    public short getShort() {
        return ((ValueShort)this.convertTo(3)).getShort();
    }

    public BigDecimal getBigDecimal() {
        return ((ValueDecimal)this.convertTo(6)).getBigDecimal();
    }

    public double getDouble() {
        return ((ValueDouble)this.convertTo(7)).getDouble();
    }

    public float getFloat() {
        return ((ValueFloat)this.convertTo(8)).getFloat();
    }

    public int getInt() {
        return ((ValueInt)this.convertTo(4)).getInt();
    }

    public long getLong() {
        return ((ValueLong)this.convertTo(5)).getLong();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytesNoCopy());
    }

    public InputStream getInputStream(long l, long l2) {
        byte[] byArray = this.getBytesNoCopy();
        long l3 = l - 1L;
        Value.rangeCheck(l3, l2, byArray.length);
        return new ByteArrayInputStream(byArray, (int)l3, (int)l2);
    }

    public Reader getReader() {
        return new StringReader(this.getString());
    }

    public Reader getReader(long l, long l2) {
        String string2 = this.getString();
        long l3 = l - 1L;
        Value.rangeCheck(l3, l2, string2.length());
        int n = (int)l3;
        return new StringReader(string2.substring(n, n + (int)l2));
    }

    public Value add(Value value) {
        throw this.throwUnsupportedExceptionForType("+");
    }

    public int getSignum() {
        throw this.throwUnsupportedExceptionForType("SIGNUM");
    }

    public Value negate() {
        throw this.throwUnsupportedExceptionForType("NEG");
    }

    public Value subtract(Value value) {
        throw this.throwUnsupportedExceptionForType("-");
    }

    public Value divide(Value value) {
        throw this.throwUnsupportedExceptionForType("/");
    }

    public Value multiply(Value value) {
        throw this.throwUnsupportedExceptionForType("*");
    }

    public Value modulus(Value value) {
        throw this.throwUnsupportedExceptionForType("%");
    }

    public Value convertTo(int n) {
        return this.convertTo(n, -1, null);
    }

    public Value convertToEnum(String[] stringArray) {
        return this.convertTo(25, -1, null, null, stringArray);
    }

    public final Value convertTo(int n, int n2, Mode mode) {
        return this.convertTo(n, n2, mode, null, null);
    }

    public Value convertTo(int n, int n2, Mode mode, Object object, String[] stringArray) {
        if (this.getType() == n) {
            return this;
        }
        try {
            switch (n) {
                case 1: {
                    switch (this.getType()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            return ValueBoolean.get(this.getSignum() != 0);
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 19: 
                        case 20: 
                        case 24: 
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueByte.get(this.getBoolean() ? (byte)1 : 0);
                        }
                        case 3: 
                        case 4: 
                        case 25: {
                            return ValueByte.get(Value.convertToByte(this.getInt(), object));
                        }
                        case 5: {
                            return ValueByte.get(Value.convertToByte(this.getLong(), object));
                        }
                        case 6: {
                            return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getBigDecimal(), object), object));
                        }
                        case 7: {
                            return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getDouble(), object), object));
                        }
                        case 8: {
                            return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getFloat(), object), object));
                        }
                        case 12: {
                            return ValueByte.get((byte)Integer.parseInt(this.getString(), 16));
                        }
                        case 24: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueShort.get(this.getBoolean() ? (short)1 : 0);
                        }
                        case 2: {
                            return ValueShort.get(this.getByte());
                        }
                        case 4: 
                        case 25: {
                            return ValueShort.get(Value.convertToShort(this.getInt(), object));
                        }
                        case 5: {
                            return ValueShort.get(Value.convertToShort(this.getLong(), object));
                        }
                        case 6: {
                            return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getBigDecimal(), object), object));
                        }
                        case 7: {
                            return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getDouble(), object), object));
                        }
                        case 8: {
                            return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getFloat(), object), object));
                        }
                        case 12: {
                            return ValueShort.get((short)Integer.parseInt(this.getString(), 16));
                        }
                        case 24: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueInt.get(this.getBoolean() ? 1 : 0);
                        }
                        case 2: 
                        case 3: 
                        case 25: {
                            return ValueInt.get(this.getInt());
                        }
                        case 5: {
                            return ValueInt.get(Value.convertToInt(this.getLong(), object));
                        }
                        case 6: {
                            return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getBigDecimal(), object), object));
                        }
                        case 7: {
                            return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getDouble(), object), object));
                        }
                        case 8: {
                            return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getFloat(), object), object));
                        }
                        case 12: {
                            return ValueInt.get((int)Long.parseLong(this.getString(), 16));
                        }
                        case 24: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 5: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueLong.get(this.getBoolean() ? 1L : 0L);
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 25: {
                            return ValueLong.get(this.getInt());
                        }
                        case 6: {
                            return ValueLong.get(Value.convertToLong(this.getBigDecimal(), object));
                        }
                        case 7: {
                            return ValueLong.get(Value.convertToLong(this.getDouble(), object));
                        }
                        case 8: {
                            return ValueLong.get(Value.convertToLong(this.getFloat(), object));
                        }
                        case 12: {
                            byte[] byArray = this.getBytes();
                            if (byArray.length == 8) {
                                return ValueLong.get(Bits.readLong(byArray, 0));
                            }
                            return ValueLong.get(Long.parseLong(this.getString(), 16));
                        }
                        case 24: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 6: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueDecimal.get(BigDecimal.valueOf(this.getBoolean() ? 1L : 0L));
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 25: {
                            return ValueDecimal.get(BigDecimal.valueOf(this.getInt()));
                        }
                        case 5: {
                            return ValueDecimal.get(BigDecimal.valueOf(this.getLong()));
                        }
                        case 7: {
                            double d = this.getDouble();
                            if (Double.isInfinite(d) || Double.isNaN(d)) {
                                throw DbException.get(22018, "" + d);
                            }
                            return ValueDecimal.get(BigDecimal.valueOf(d));
                        }
                        case 8: {
                            float f = this.getFloat();
                            if (Float.isInfinite(f) || Float.isNaN(f)) {
                                throw DbException.get(22018, "" + f);
                            }
                            return ValueDecimal.get(new BigDecimal(Float.toString(f)));
                        }
                        case 24: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 7: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueDouble.get(this.getBoolean() ? 1.0 : 0.0);
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            return ValueDouble.get(this.getInt());
                        }
                        case 5: {
                            return ValueDouble.get(this.getLong());
                        }
                        case 6: {
                            return ValueDouble.get(this.getBigDecimal().doubleValue());
                        }
                        case 8: {
                            return ValueDouble.get(this.getFloat());
                        }
                        case 24: 
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 8: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueFloat.get(this.getBoolean() ? 1.0f : 0.0f);
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            return ValueFloat.get(this.getInt());
                        }
                        case 5: {
                            return ValueFloat.get(this.getLong());
                        }
                        case 6: {
                            return ValueFloat.get(this.getBigDecimal().floatValue());
                        }
                        case 7: {
                            return ValueFloat.get((float)this.getDouble());
                        }
                        case 24: 
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 10: {
                    switch (this.getType()) {
                        case 9: {
                            return ValueDate.fromDateValue(1008673L);
                        }
                        case 11: {
                            return ValueDate.fromDateValue(((ValueTimestamp)this).getDateValue());
                        }
                        case 24: {
                            ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                            long l = valueTimestampTimeZone.getDateValue();
                            long l2 = valueTimestampTimeZone.getTimeNanos();
                            long l3 = DateTimeUtils.getMillis(l, l2, valueTimestampTimeZone.getTimeZoneOffsetMins());
                            return ValueDate.fromMillis(l3);
                        }
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 9: {
                    switch (this.getType()) {
                        case 10: {
                            return ValueTime.fromNanos(0L);
                        }
                        case 11: {
                            return ValueTime.fromNanos(((ValueTimestamp)this).getTimeNanos());
                        }
                        case 24: {
                            ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                            long l = valueTimestampTimeZone.getDateValue();
                            long l4 = valueTimestampTimeZone.getTimeNanos();
                            long l5 = DateTimeUtils.getMillis(l, l4, valueTimestampTimeZone.getTimeZoneOffsetMins());
                            return ValueTime.fromNanos(DateTimeUtils.nanosFromDate(l5) + l4 % 1000000L);
                        }
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 11: {
                    switch (this.getType()) {
                        case 9: {
                            return DateTimeUtils.normalizeTimestamp(0L, ((ValueTime)this).getNanos());
                        }
                        case 10: {
                            return ValueTimestamp.fromDateValueAndNanos(((ValueDate)this).getDateValue(), 0L);
                        }
                        case 24: {
                            ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                            long l = valueTimestampTimeZone.getDateValue();
                            long l6 = valueTimestampTimeZone.getTimeNanos();
                            long l7 = DateTimeUtils.getMillis(l, l6, valueTimestampTimeZone.getTimeZoneOffsetMins());
                            return ValueTimestamp.fromMillisNanos(l7, (int)(l6 % 1000000L));
                        }
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 24: {
                    switch (this.getType()) {
                        case 9: {
                            ValueTimestamp valueTimestamp = DateTimeUtils.normalizeTimestamp(0L, ((ValueTime)this).getNanos());
                            return DateTimeUtils.timestampTimeZoneFromLocalDateValueAndNanos(valueTimestamp.getDateValue(), valueTimestamp.getTimeNanos());
                        }
                        case 10: {
                            return DateTimeUtils.timestampTimeZoneFromLocalDateValueAndNanos(((ValueDate)this).getDateValue(), 0L);
                        }
                        case 11: {
                            ValueTimestamp valueTimestamp = (ValueTimestamp)this;
                            return DateTimeUtils.timestampTimeZoneFromLocalDateValueAndNanos(valueTimestamp.getDateValue(), valueTimestamp.getTimeNanos());
                        }
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 12: {
                    switch (this.getType()) {
                        case 15: 
                        case 19: {
                            return ValueBytes.getNoCopy(this.getBytesNoCopy());
                        }
                        case 20: 
                        case 22: {
                            return ValueBytes.getNoCopy(this.getBytes());
                        }
                        case 2: {
                            return ValueBytes.getNoCopy(new byte[]{this.getByte()});
                        }
                        case 3: {
                            short s2 = this.getShort();
                            return ValueBytes.getNoCopy(new byte[]{(byte)(s2 >> 8), (byte)s2});
                        }
                        case 4: {
                            byte[] byArray = new byte[4];
                            Bits.writeInt(byArray, 0, this.getInt());
                            return ValueBytes.getNoCopy(byArray);
                        }
                        case 5: {
                            byte[] byArray = new byte[8];
                            Bits.writeLong(byArray, 0, this.getLong());
                            return ValueBytes.getNoCopy(byArray);
                        }
                        case 24: 
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 19: {
                    switch (this.getType()) {
                        case 12: 
                        case 15: {
                            return ValueJavaObject.getNoCopy(null, this.getBytesNoCopy(), this.getDataHandler());
                        }
                        case 24: 
                        case 25: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 25: {
                    switch (this.getType()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            return ValueEnum.get(stringArray, this.getInt());
                        }
                        case 13: 
                        case 14: 
                        case 21: {
                            return ValueEnum.get(stringArray, this.getString());
                        }
                    }
                    throw DbException.get(22018, this.getString());
                }
                case 15: {
                    switch (this.getType()) {
                        case 12: {
                            return ValueLobDb.createSmallLob(15, this.getBytesNoCopy());
                        }
                        case 24: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 20: {
                    switch (this.getType()) {
                        case 12: {
                            return ValueUuid.get(this.getBytesNoCopy());
                        }
                        case 19: {
                            Object object2 = JdbcUtils.deserialize(this.getBytesNoCopy(), this.getDataHandler());
                            if (object2 instanceof UUID) {
                                return ValueUuid.get((UUID)object2);
                            }
                            throw DbException.get(22018, this.getString());
                        }
                        case 24: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 22: {
                    switch (this.getType()) {
                        case 12: {
                            return ValueGeometry.get(this.getBytesNoCopy());
                        }
                        case 19: {
                            Object object3 = JdbcUtils.deserialize(this.getBytesNoCopy(), this.getDataHandler());
                            if (DataType.isGeometry(object3)) {
                                return ValueGeometry.getFromGeometry(object3);
                            }
                        }
                        case 24: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                }
            }
            String string2 = this.getString();
            switch (n) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 1: {
                    if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("y")) {
                        return ValueBoolean.TRUE;
                    }
                    if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("f") || string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("n")) {
                        return ValueBoolean.FALSE;
                    }
                    return ValueBoolean.get(new BigDecimal(string2).signum() != 0);
                }
                case 2: {
                    return ValueByte.get(Byte.parseByte(string2.trim()));
                }
                case 3: {
                    return ValueShort.get(Short.parseShort(string2.trim()));
                }
                case 4: {
                    return ValueInt.get(Integer.parseInt(string2.trim()));
                }
                case 5: {
                    return ValueLong.get(Long.parseLong(string2.trim()));
                }
                case 6: {
                    return ValueDecimal.get(new BigDecimal(string2.trim()));
                }
                case 9: {
                    return ValueTime.parse(string2.trim());
                }
                case 10: {
                    return ValueDate.parse(string2.trim());
                }
                case 11: {
                    return ValueTimestamp.parse(string2.trim(), mode);
                }
                case 24: {
                    return ValueTimestampTimeZone.parse(string2.trim());
                }
                case 12: {
                    return ValueBytes.getNoCopy(StringUtils.convertHexToBytes(string2.trim()));
                }
                case 19: {
                    return ValueJavaObject.getNoCopy(null, StringUtils.convertHexToBytes(string2.trim()), this.getDataHandler());
                }
                case 13: {
                    return ValueString.get(string2);
                }
                case 14: {
                    return ValueStringIgnoreCase.get(string2);
                }
                case 21: {
                    return ValueStringFixed.get(string2, n2, mode);
                }
                case 7: {
                    return ValueDouble.get(Double.parseDouble(string2.trim()));
                }
                case 8: {
                    return ValueFloat.get(Float.parseFloat(string2.trim()));
                }
                case 16: {
                    return ValueLobDb.createSmallLob(16, string2.getBytes(StandardCharsets.UTF_8));
                }
                case 15: {
                    return ValueLobDb.createSmallLob(15, StringUtils.convertHexToBytes(string2.trim()));
                }
                case 17: {
                    return ValueArray.get(new Value[]{ValueString.get(string2)});
                }
                case 18: {
                    SimpleResultSet simpleResultSet = new SimpleResultSet();
                    simpleResultSet.setAutoClose(false);
                    simpleResultSet.addColumn("X", 12, string2.length(), 0);
                    simpleResultSet.addRow(string2);
                    return ValueResultSet.get(simpleResultSet);
                }
                case 20: {
                    return ValueUuid.get(string2);
                }
                case 22: {
                    return ValueGeometry.get(string2);
                }
            }
            if (JdbcUtils.customDataTypesHandler != null) {
                return JdbcUtils.customDataTypesHandler.convert(this, n);
            }
            throw DbException.throwInternalError("type=" + n);
        }
        catch (NumberFormatException numberFormatException) {
            throw DbException.get(22018, numberFormatException, this.getString());
        }
    }

    public final int compareTypeSafe(Value value, CompareMode compareMode) {
        if (this == value) {
            return 0;
        }
        if (this == ValueNull.INSTANCE) {
            return -1;
        }
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        return this.compareSecure(value, compareMode);
    }

    public final int compareTo(Value value, CompareMode compareMode) {
        if (this == value) {
            return 0;
        }
        if (this == ValueNull.INSTANCE) {
            return value == ValueNull.INSTANCE ? 0 : -1;
        }
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        if (this.getType() == value.getType()) {
            return this.compareSecure(value, compareMode);
        }
        int n = Value.getHigherOrder(this.getType(), value.getType());
        return this.convertTo(n).compareSecure(value.convertTo(n), compareMode);
    }

    public int getScale() {
        return 0;
    }

    public Value convertScale(boolean bl, int n) {
        return this;
    }

    public Value convertPrecision(long l, boolean bl) {
        return this;
    }

    private static byte convertToByte(long l, Object object) {
        if (l > 127L || l < -128L) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (byte)l;
    }

    private static short convertToShort(long l, Object object) {
        if (l > 32767L || l < -32768L) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (short)l;
    }

    private static int convertToInt(long l, Object object) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (int)l;
    }

    private static long convertToLong(double d, Object object) {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw DbException.get(22004, Double.toString(d), Value.getColumnName(object));
        }
        return Math.round(d);
    }

    private static long convertToLong(BigDecimal bigDecimal, Object object) {
        if (bigDecimal.compareTo(MAX_LONG_DECIMAL) > 0 || bigDecimal.compareTo(MIN_LONG_DECIMAL) < 0) {
            throw DbException.get(22004, bigDecimal.toString(), Value.getColumnName(object));
        }
        return bigDecimal.setScale(0, 4).longValue();
    }

    private static String getColumnName(Object object) {
        return object == null ? "" : object.toString();
    }

    public Value copy(DataHandler dataHandler, int n) {
        return this;
    }

    public boolean isLinkedToTable() {
        return false;
    }

    public void remove() {
    }

    public boolean checkPrecision(long l) {
        return this.getPrecision() <= l;
    }

    public String getTraceSQL() {
        return this.getSQL();
    }

    public String toString() {
        return this.getTraceSQL();
    }

    protected DbException throwUnsupportedExceptionForType(String string2) {
        throw DbException.getUnsupportedException(DataType.getDataType((int)this.getType()).name + " " + string2);
    }

    public int getTableId() {
        return 0;
    }

    public byte[] getSmall() {
        return null;
    }

    public Value copyToTemp() {
        return this;
    }

    public Value copyToResult() {
        return this;
    }

    public ResultSet getResultSet() {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.setAutoClose(false);
        simpleResultSet.addColumn("X", DataType.convertTypeToSQLType(this.getType()), MathUtils.convertLongToInt(this.getPrecision()), this.getScale());
        simpleResultSet.addRow(this.getObject());
        return simpleResultSet;
    }

    protected DataHandler getDataHandler() {
        return null;
    }

    public static interface ValueBlob {
    }

    public static interface ValueClob {
    }
}

