/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.value;

import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ValueString
extends Value {
    private static final ValueString EMPTY = new ValueString("");
    protected final String value;

    protected ValueString(String string2) {
        this.value = string2;
    }

    @Override
    public String getSQL() {
        return StringUtils.quoteStringSQL(this.value);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueString && this.value.equals(((ValueString)object).value);
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueString valueString = (ValueString)value;
        return compareMode.compareString(this.value, valueString.value, false);
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public long getPrecision() {
        return this.value.length();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, this.value);
    }

    @Override
    public int getDisplaySize() {
        return this.value.length();
    }

    @Override
    public int getMemory() {
        return this.value.length() * 2 + 48;
    }

    @Override
    public Value convertPrecision(long l, boolean bl) {
        if (l == 0L || (long)this.value.length() <= l) {
            return this;
        }
        int n = MathUtils.convertLongToInt(l);
        return this.getNew(this.value.substring(0, n));
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int getType() {
        return 13;
    }

    public static Value get(String string2) {
        return ValueString.get(string2, false);
    }

    public static Value get(String string2, boolean bl) {
        if (string2.isEmpty()) {
            return bl ? ValueNull.INSTANCE : EMPTY;
        }
        ValueString valueString = new ValueString(StringUtils.cache(string2));
        if (string2.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueString;
        }
        return Value.cache(valueString);
    }

    protected Value getNew(String string2) {
        return ValueString.get(string2);
    }
}

