/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.value;

import com.alibaba.schedulerx.shade.org.h2.api.TimestampWithTimeZone;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.DateTimeUtils;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class ValueTimestampTimeZone
extends Value {
    public static final int DEFAULT_PRECISION = 32;
    public static final int MAXIMUM_PRECISION = 35;
    static final int DEFAULT_SCALE = 6;
    static final int MAXIMUM_SCALE = 9;
    private final long dateValue;
    private final long timeNanos;
    private final short timeZoneOffsetMins;

    public static int getDisplaySize(int n) {
        return n == 0 ? 25 : 26 + n;
    }

    private ValueTimestampTimeZone(long l, long l2, short s2) {
        if (l2 < 0L || l2 >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + l2);
        }
        if (s2 < -1080 || s2 > 1080) {
            throw new IllegalArgumentException("timeZoneOffsetMins out of range " + s2);
        }
        this.dateValue = l;
        this.timeNanos = l2;
        this.timeZoneOffsetMins = s2;
    }

    public static ValueTimestampTimeZone fromDateValueAndNanos(long l, long l2, short s2) {
        return (ValueTimestampTimeZone)Value.cache(new ValueTimestampTimeZone(l, l2, s2));
    }

    public static ValueTimestampTimeZone get(TimestampWithTimeZone timestampWithTimeZone) {
        return ValueTimestampTimeZone.fromDateValueAndNanos(timestampWithTimeZone.getYMD(), timestampWithTimeZone.getNanosSinceMidnight(), timestampWithTimeZone.getTimeZoneOffsetMins());
    }

    public static ValueTimestampTimeZone parse(String string2) {
        try {
            return (ValueTimestampTimeZone)DateTimeUtils.parseTimestamp(string2, null, true);
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIMESTAMP WITH TIME ZONE", string2);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    public short getTimeZoneOffsetMins() {
        return this.timeZoneOffsetMins;
    }

    @Override
    public Timestamp getTimestamp() {
        return DateTimeUtils.convertTimestampTimeZoneToTimestamp(this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public String getString() {
        return DateTimeUtils.timestampTimeZoneToString(this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP WITH TIME ZONE '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 35L;
    }

    @Override
    public int getScale() {
        return 9;
    }

    @Override
    public int getDisplaySize() {
        return 35;
    }

    @Override
    public boolean checkPrecision(long l) {
        return true;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 9) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.timeNanos;
        long l2 = DateTimeUtils.convertScale(l, n);
        if (l2 == l) {
            return this;
        }
        long l3 = this.dateValue;
        if (l2 >= 86400000000000L) {
            l2 -= 86400000000000L;
            l3 = DateTimeUtils.incrementDateValue(l3);
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(l3, l2, this.timeZoneOffsetMins);
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
        long l = this.dateValue;
        long l2 = this.timeNanos - (long)this.timeZoneOffsetMins * 60000000000L;
        if (l2 < 0L) {
            l2 += 86400000000000L;
            l = DateTimeUtils.decrementDateValue(l);
        } else if (l2 >= 86400000000000L) {
            l2 -= 86400000000000L;
            l = DateTimeUtils.incrementDateValue(l);
        }
        long l3 = valueTimestampTimeZone.dateValue;
        long l4 = valueTimestampTimeZone.timeNanos - (long)valueTimestampTimeZone.timeZoneOffsetMins * 60000000000L;
        if (l4 < 0L) {
            l4 += 86400000000000L;
            l3 = DateTimeUtils.decrementDateValue(l3);
        } else if (l4 >= 86400000000000L) {
            l4 -= 86400000000000L;
            l3 = DateTimeUtils.incrementDateValue(l3);
        }
        int n = Long.compare(l, l3);
        if (n != 0) {
            return n;
        }
        return Long.compare(l2, l4);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestampTimeZone)) {
            return false;
        }
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)object;
        return this.dateValue == valueTimestampTimeZone.dateValue && this.timeNanos == valueTimestampTimeZone.timeNanos && this.timeZoneOffsetMins == valueTimestampTimeZone.timeZoneOffsetMins;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32 ^ (long)this.timeZoneOffsetMins);
    }

    @Override
    public Object getObject() {
        return new TimestampWithTimeZone(this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, this.getString());
    }

    @Override
    public Value add(Value value) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIME ZONE values is unsupported");
    }

    @Override
    public Value subtract(Value value) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIME ZONE values is unsupported");
    }
}

