/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelState;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.MessageEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioServerBoss;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;

class NioServerSocketPipelineSink
extends AbstractNioChannelSink {
    NioServerSocketPipelineSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            NioServerSocketPipelineSink.handleServerSocket(e);
        } else if (channel instanceof NioSocketChannel) {
            NioServerSocketPipelineSink.handleAcceptedSocket(e);
        }
    }

    private static void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        NioServerSocketChannel channel = (NioServerSocketChannel)event.getChannel();
        ChannelFuture future2 = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                ((NioServerBoss)channel.boss).close(channel, future2);
                break;
            }
            case BOUND: {
                if (value != null) {
                    ((NioServerBoss)channel.boss).bind(channel, future2, (SocketAddress)value);
                    break;
                }
                ((NioServerBoss)channel.boss).close(channel, future2);
                break;
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            ChannelFuture future2 = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future2);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.worker.close(channel, future2);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future2, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }
}

