/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFutureListener;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelState;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channels;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.MessageEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.AbstractOioChannelSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.AbstractOioWorker;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.OioDatagramChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.OioDatagramWorker;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.ThreadNameDeterminer;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.ThreadRenamingRunnable;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.internal.DeadLockProofWorker;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

class OioDatagramPipelineSink
extends AbstractOioChannelSink {
    private final Executor workerExecutor;
    private final ThreadNameDeterminer determiner;

    OioDatagramPipelineSink(Executor workerExecutor, ThreadNameDeterminer determiner) {
        this.workerExecutor = workerExecutor;
        this.determiner = determiner;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        OioDatagramChannel channel = (OioDatagramChannel)e.getChannel();
        ChannelFuture future2 = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    AbstractOioWorker.close(channel, future2);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        this.bind(channel, future2, (SocketAddress)value);
                        break;
                    }
                    AbstractOioWorker.close(channel, future2);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future2, (SocketAddress)value);
                        break;
                    }
                    OioDatagramWorker.disconnect(channel, future2);
                    break;
                }
                case INTEREST_OPS: {
                    AbstractOioWorker.setInterestOps(channel, future2, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent evt = (MessageEvent)e;
            OioDatagramWorker.write(channel, future2, evt.getMessage(), evt.getRemoteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bind(OioDatagramChannel channel, ChannelFuture future2, SocketAddress localAddress) {
        boolean bound2 = false;
        boolean workerStarted = false;
        try {
            try {
                channel.socket.bind(localAddress);
                bound2 = true;
                future2.setSuccess();
                Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                DeadLockProofWorker.start(this.workerExecutor, new ThreadRenamingRunnable(new OioDatagramWorker(channel), "Old I/O datagram worker (" + channel + ')', this.determiner));
                workerStarted = true;
            }
            catch (Throwable t) {
                future2.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var8_7 = null;
                if (!bound2) return;
                if (workerStarted) return;
                AbstractOioWorker.close(channel, future2);
                return;
            }
            Object var8_6 = null;
            if (!bound2) return;
            if (workerStarted) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!bound2) throw throwable;
            if (workerStarted) throw throwable;
            AbstractOioWorker.close(channel, future2);
            throw throwable;
        }
        AbstractOioWorker.close(channel, future2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect(OioDatagramChannel channel, ChannelFuture future2, SocketAddress remoteAddress) {
        boolean bound2 = channel.isBound();
        boolean connected2 = false;
        boolean workerStarted = false;
        future2.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        channel.remoteAddress = null;
        try {
            try {
                channel.socket.connect(remoteAddress);
                connected2 = true;
                future2.setSuccess();
                if (!bound2) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                String threadName = "Old I/O datagram worker (" + channel + ')';
                if (!bound2) {
                    DeadLockProofWorker.start(this.workerExecutor, new ThreadRenamingRunnable(new OioDatagramWorker(channel), threadName, this.determiner));
                } else {
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null) {
                        try {
                            workerThread.setName(threadName);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                }
                workerStarted = true;
            }
            catch (Throwable t) {
                future2.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var11_12 = null;
                if (!connected2) return;
                if (workerStarted) return;
                AbstractOioWorker.close(channel, future2);
                return;
            }
            Object var11_11 = null;
            if (!connected2) return;
            if (workerStarted) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!connected2) throw throwable;
            if (workerStarted) throw throwable;
            AbstractOioWorker.close(channel, future2);
            throw throwable;
        }
        AbstractOioWorker.close(channel, future2);
    }
}

