/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.actor;

import akka.dispatch.ExecutionContexts;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.scala.concurrent.ExecutionContext;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public enum FutureExecutorPool {
    INSTANCE;

    private Map<String, ExecutionContext> executorPool = Maps.newConcurrentMap();

    public ExecutionContext get(final String name) {
        if (!this.executorPool.containsKey(name)) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(16, 16, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                int index = 0;

                @Override
                public Thread newThread(Runnable r) {
                    ++this.index;
                    return new Thread(r, "Schedulerx-FutureExecutor-" + name + "-" + this.index);
                }
            });
            this.executorPool.put(name, ExecutionContexts.fromExecutor(executor));
        }
        return this.executorPool.get(name);
    }

    public void addExecutor(String name, ThreadPoolExecutor executor) {
        this.executorPool.put(name, ExecutionContexts.fromExecutor(executor));
    }
}

