/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.actor;

import akka.actor.UntypedActor;
import com.alibaba.fastjson.JSON;
import com.alibaba.schedulerx.common.domain.Metrics;
import com.alibaba.schedulerx.common.domain.TaskDispatchMode;
import com.alibaba.schedulerx.common.monitor.MetricsCollector;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.worker.container.ThreadContainerPool;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import com.alibaba.schedulerx.worker.pull.PullManager;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;

public class WorkerHeartbeatActor
extends UntypedActor {
    private TaskMasterPool taskMasterPool = TaskMasterPool.INSTANCE;

    @Override
    public void onReceive(Object obj) throws Throwable {
        if (obj instanceof Worker.MasterCheckWorkerAliveRequest) {
            this.handleCheckWorkerAlive((Worker.MasterCheckWorkerAliveRequest)obj);
        } else if (obj instanceof Worker.ContainerCheckZombieRequest) {
            this.handleCheckZombie((Worker.ContainerCheckZombieRequest)obj);
        } else if (obj instanceof Worker.WorkerOfflineRequest) {
            this.handleWorkerOffline((Worker.WorkerOfflineRequest)obj);
        }
    }

    private void handleWorkerOffline(Worker.WorkerOfflineRequest request) {
        TaskMaster taskMaster = TaskMasterPool.INSTANCE.get(request.getJobInstanceId());
        if (taskMaster != null) {
            if (request.getShutdown()) {
                taskMaster.handleWorkerShutdown(request.getWorkerIdAddr(), true);
            } else {
                taskMaster.handleWorkerOffline(request.getWorkerIdAddr());
            }
        }
        Worker.WorkerOfflineResponse response = Worker.WorkerOfflineResponse.newBuilder().setSuccess(true).build();
        this.getSender().tell(response, this.getSelf());
    }

    private void handleCheckWorkerAlive(Worker.MasterCheckWorkerAliveRequest request) {
        Worker.MasterCheckWorkerAliveResponse response;
        long jobInstanceId = request.getJobInstanceId();
        if (request.hasDispatchMode() && request.getDispatchMode().equals(TaskDispatchMode.PULL.getValue()) && PullManager.INSTANCE.contains(jobInstanceId) && PullManager.INSTANCE.isCrashed(jobInstanceId)) {
            response = Worker.MasterCheckWorkerAliveResponse.newBuilder().setSuccess(false).setMessage(request.getJobInstanceId() + "  is crashed in PullMananger").build();
        } else {
            Metrics metrics = MetricsCollector.getMetrics();
            ThreadPoolExecutor sharedThreadPool = ThreadContainerPool.getInstance().getSharedThreadPool();
            if (sharedThreadPool != null && metrics != null) {
                Integer availableSize = sharedThreadPool.getCorePoolSize() - sharedThreadPool.getActiveCount() + ((int)Math.sqrt(sharedThreadPool.getCorePoolSize()) - sharedThreadPool.getQueue().size());
                metrics.setSharePoolAvailableSize(availableSize);
            }
            response = Worker.MasterCheckWorkerAliveResponse.newBuilder().setSuccess(true).setMetricsJson(metrics != null ? JSON.toJSONString((Object)metrics) : "").build();
        }
        this.getSender().tell(response, this.getSelf());
    }

    private void handleCheckZombie(Worker.ContainerCheckZombieRequest request) {
        ArrayList<Long> zombieJobInstanceIds = Lists.newArrayList();
        for (Long jobInstanceId : request.getJobInstanceIdList()) {
            if (this.taskMasterPool.contains(jobInstanceId)) continue;
            zombieJobInstanceIds.add(jobInstanceId);
        }
        Worker.ContainerCheckZombieResponse response = Worker.ContainerCheckZombieResponse.newBuilder().addAllZombieJobInstanceId(zombieJobInstanceIds).build();
        this.getSender().tell(response, this.getSelf());
    }
}

