/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.batch;

import com.alibaba.fastjson.JSON;
import com.alibaba.schedulerx.common.domain.Metrics;
import com.alibaba.schedulerx.common.domain.Pair;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.monitor.MetricsCollector;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.batch.BaseReqHandler;
import com.alibaba.schedulerx.worker.batch.ReqQueue;
import com.alibaba.schedulerx.worker.container.ThreadContainerPool;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.util.WorkerConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public class ContainerStatusReqHandler<T>
extends BaseReqHandler<T> {
    private String taskMasterAkkaPath;
    private static final Logger LOGGER = LogFactory.getLogger(ContainerStatusReqHandler.class);

    @Override
    public void process(long jobInstanceId, List<T> reqs, String workerAddr) {
        this.batchProcessSvc.submit(new BatchStatuesReportRunnable(jobInstanceId, reqs));
    }

    public ContainerStatusReqHandler(long jobInstanceId, int coreBatchThreadNum, int maxBatchThreadNum, int batchSize, ReqQueue<T> queue, String taskMasterAkkaPath) {
        super(jobInstanceId, coreBatchThreadNum, maxBatchThreadNum, batchSize, queue, "Schedulerx-Container-Batch-Statuses-Process-Thread-", "Schedulerx-Container-Batch-Statues-Retrieve-Thread-");
        this.taskMasterAkkaPath = taskMasterAkkaPath;
    }

    public String getTaskMasterAkkaPath() {
        return this.taskMasterAkkaPath;
    }

    private class BatchStatuesReportRunnable
    implements Runnable {
        private long jobInstanceId;
        private List<Worker.ContainerReportTaskStatusRequest> statues;

        BatchStatuesReportRunnable(long jobInstanceId, List<Worker.ContainerReportTaskStatusRequest> reqs) {
            this.jobInstanceId = jobInstanceId;
            this.statues = reqs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                boolean enableShareContainerPool = WorkerConfigUtil.isEnableShareContainerPool();
                if (enableShareContainerPool) {
                    HashMap<Object, ArrayList<Worker.ContainerReportTaskStatusRequest>> taskStatusRequestMap = Maps.newHashMap();
                    for (Worker.ContainerReportTaskStatusRequest containerReportTaskStatusRequest : this.statues) {
                        long jobInstanceId = containerReportTaskStatusRequest.getJobInstanceId();
                        long serialNum = containerReportTaskStatusRequest.getSerialNum();
                        Pair<Long, Long> key = new Pair<Long, Long>(jobInstanceId, serialNum);
                        if (taskStatusRequestMap.containsKey(key)) {
                            ((List)taskStatusRequestMap.get(key)).add(containerReportTaskStatusRequest);
                            continue;
                        }
                        ArrayList<Worker.ContainerReportTaskStatusRequest> reqsByInstance = Lists.newArrayList(containerReportTaskStatusRequest);
                        taskStatusRequestMap.put(key, reqsByInstance);
                    }
                    for (Map.Entry entry : taskStatusRequestMap.entrySet()) {
                        void var6_19;
                        Pair entryKey = (Pair)entry.getKey();
                        Object var6_20 = null;
                        ArrayList<Worker.TaskStatusInfo> taskStatuses = Lists.newArrayList();
                        int finishCount = 0;
                        for (Worker.ContainerReportTaskStatusRequest req : (List)entry.getValue()) {
                            String string2 = req.getInstanceMasterActorPath();
                            Worker.TaskStatusInfo.Builder builder = Worker.TaskStatusInfo.newBuilder().setTaskId(req.getTaskId()).setStatus(req.getStatus());
                            if (req.hasTaskName()) {
                                builder.setTaskName(req.getTaskName());
                            }
                            if (req.hasResult()) {
                                builder.setResult(req.getResult());
                            }
                            if (req.hasProgress()) {
                                builder.setProgress(req.getProgress());
                            }
                            if (req.hasTraceId()) {
                                builder.setTraceId(req.getTraceId());
                            }
                            if (TaskStatus.parseValue(req.getStatus()).isFinish()) {
                                ++finishCount;
                            }
                            taskStatuses.add(builder.build());
                        }
                        if (var6_19 != null) {
                            Worker.ContainerReportTaskStatusRequest taskStatusRequest = (Worker.ContainerReportTaskStatusRequest)((List)entry.getValue()).get(0);
                            Metrics metrics = null;
                            ThreadPoolExecutor sharedThreadPool = ThreadContainerPool.getInstance().getSharedThreadPool();
                            if (finishCount > 0 && sharedThreadPool != null && (metrics = MetricsCollector.getMetrics()) != null) {
                                Integer availableSize = sharedThreadPool.getCorePoolSize() - sharedThreadPool.getActiveCount() + ((int)Math.sqrt(sharedThreadPool.getCorePoolSize()) - sharedThreadPool.getQueue().size()) + finishCount;
                                metrics.setSharePoolAvailableSize(availableSize);
                            }
                            Worker.ContainerBatchReportTaskStatuesRequest request = Worker.ContainerBatchReportTaskStatuesRequest.newBuilder().setJobId(taskStatusRequest.getJobId()).setJobInstanceId((Long)entryKey.getFirst()).addAllTaskStatues(taskStatuses).setTaskMasterAkkaPath((String)var6_19).setWorkerAddr(taskStatusRequest.getWorkerAddr()).setWorkerId(taskStatusRequest.getWorkerId()).setSerialNum((Long)entryKey.getSecond()).setMetricsJson(metrics != null ? JSON.toJSONString((Object)metrics) : "").build();
                            SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(request, null);
                            LOGGER.info("jobInstanceId={}, serialNum={}, batch report status={} to task master, size:{}", entryKey.getFirst(), entryKey.getSecond(), taskStatusRequest.getStatus(), taskStatuses.size());
                            continue;
                        }
                        LOGGER.error("instanceMasterActorPath is null, jobInstanceId={}", this.jobInstanceId);
                    }
                } else {
                    Worker.ContainerReportTaskStatusRequest taskStatusRequest = this.statues.get(0);
                    HashMap hashMap = Maps.newHashMap();
                    for (Worker.ContainerReportTaskStatusRequest containerReportTaskStatusRequest : this.statues) {
                        ArrayList<Worker.TaskStatusInfo> taskStatuses;
                        Worker.TaskStatusInfo.Builder builder = Worker.TaskStatusInfo.newBuilder().setTaskId(containerReportTaskStatusRequest.getTaskId()).setStatus(containerReportTaskStatusRequest.getStatus());
                        if (containerReportTaskStatusRequest.hasTaskName()) {
                            builder.setTaskName(containerReportTaskStatusRequest.getTaskName());
                        }
                        if (containerReportTaskStatusRequest.hasResult()) {
                            builder.setResult(containerReportTaskStatusRequest.getResult());
                        }
                        if (containerReportTaskStatusRequest.hasProgress()) {
                            builder.setProgress(containerReportTaskStatusRequest.getProgress());
                        }
                        if (containerReportTaskStatusRequest.hasTraceId()) {
                            builder.setTraceId(containerReportTaskStatusRequest.getTraceId());
                        }
                        if ((taskStatuses = (ArrayList<Worker.TaskStatusInfo>)hashMap.get(containerReportTaskStatusRequest.getSerialNum())) == null) {
                            taskStatuses = Lists.newArrayList();
                            hashMap.put(containerReportTaskStatusRequest.getSerialNum(), taskStatuses);
                        }
                        taskStatuses.add(builder.build());
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        Worker.ContainerBatchReportTaskStatuesRequest request = Worker.ContainerBatchReportTaskStatuesRequest.newBuilder().setJobId(taskStatusRequest.getJobId()).setJobInstanceId(taskStatusRequest.getJobInstanceId()).addAllTaskStatues((Iterable)entry.getValue()).setTaskMasterAkkaPath(ContainerStatusReqHandler.this.taskMasterAkkaPath).setWorkerAddr(taskStatusRequest.getWorkerAddr()).setWorkerId(taskStatusRequest.getWorkerId()).setSerialNum((Long)entry.getKey()).build();
                        SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(request, null);
                        LOGGER.info("jobInstanceId={}, serialNum={}, batch report status={} to task master, size:{}", this.jobInstanceId, entry.getKey(), taskStatusRequest.getStatus(), ((List)entry.getValue()).size());
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
            finally {
                ContainerStatusReqHandler.this.activeRunnableNum.decrementAndGet();
            }
        }
    }
}

