/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.container;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.container.ActorContainer;
import com.alibaba.schedulerx.worker.container.Container;
import com.alibaba.schedulerx.worker.container.ContainerPool;
import com.alibaba.schedulerx.worker.container.DockerContainer;
import com.alibaba.schedulerx.worker.container.ProcessContainer;
import com.alibaba.schedulerx.worker.container.ThreadContainer;
import com.alibaba.schedulerx.worker.container.ThreadContainerPool;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

public class ContainerFactory {
    private static final Logger LOGGER = LogFactory.getLogger(ContainerFactory.class);
    private static String containType;
    private static ContainerPool containerPool;

    public static Container create(JobContext context) throws Exception {
        Container container = null;
        if (containType == null) {
            containType = ConfigUtil.getWorkerConfig().getString("worker.container.type", "thread");
        }
        if (containType != null) {
            if (containType.equals("thread")) {
                container = new ThreadContainer(context, ContainerFactory.getContainerPool());
            } else if (containType.equals("actor")) {
                container = new ActorContainer(context);
            } else if (containType.equals("process")) {
                container = new ProcessContainer(context);
            } else if (containType.equals("docker")) {
                container = new DockerContainer(context);
            }
        }
        return container;
    }

    public static ContainerPool getContainerPool() {
        if (containerPool == null) {
            if (containType == null) {
                containType = ConfigUtil.getWorkerConfig().getString("worker.container.type", "thread");
            }
            if (containType.equals("thread")) {
                containerPool = ThreadContainerPool.getInstance();
            }
        }
        return containerPool;
    }
}

