/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.container;

import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.worker.container.MarkedRunnable;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DualConcurrencyThreadPoolExecutor<K>
extends ThreadPoolExecutor {
    public DualConcurrencyThreadPoolExecutor(int corePoolSize, int workQueueSize) {
        super(corePoolSize, corePoolSize, 0L, TimeUnit.NANOSECONDS, new SemaphoreBlockingQueue(workQueueSize));
        super.prestartAllCoreThreads();
    }

    public DualConcurrencyThreadPoolExecutor(int corePoolSize, int workQueueSize, ThreadFactory threadFactory) {
        super(corePoolSize, corePoolSize, 0L, TimeUnit.NANOSECONDS, new SemaphoreBlockingQueue(workQueueSize), threadFactory);
        super.prestartAllCoreThreads();
    }

    public DualConcurrencyThreadPoolExecutor(int corePoolSize, int workQueueSize, RejectedExecutionHandler handler) {
        super(corePoolSize, corePoolSize, 0L, TimeUnit.NANOSECONDS, new SemaphoreBlockingQueue(workQueueSize), handler);
        super.prestartAllCoreThreads();
    }

    public DualConcurrencyThreadPoolExecutor(int corePoolSize, int workQueueSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, corePoolSize, 0L, TimeUnit.NANOSECONDS, new SemaphoreBlockingQueue(workQueueSize), threadFactory, handler);
        super.prestartAllCoreThreads();
    }

    public void registerSemaphore(K key, Integer concurrency) {
        SemaphoreBlockingQueue queue = (SemaphoreBlockingQueue)this.getQueue();
        queue.putSemaphore(key, concurrency);
    }

    public void clear(K key) {
        SemaphoreBlockingQueue queue = (SemaphoreBlockingQueue)this.getQueue();
        queue.clear(key);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        SemaphoreBlockingQueue queue = (SemaphoreBlockingQueue)this.getQueue();
        if (r instanceof MarkedRunnable) {
            queue.releaseSemaphore(((MarkedRunnable)r).identify());
        }
    }

    protected RunnableFuture newTaskFor(Runnable runnable, Object value) {
        return new MarkedFutureTask((MarkedRunnable)runnable, value);
    }

    static class SemaphoreBlockingQueue<T>
    extends LinkedBlockingQueue<MarkedRunnable<T>> {
        private final Map<T, Semaphore> semaphoreMap = Maps.newHashMap();
        private final Map<T, Queue<MarkedRunnable<T>>> waitQueueMap = Maps.newHashMap();
        private final AtomicInteger waitCount = new AtomicInteger();

        public SemaphoreBlockingQueue(int size2) {
            super(size2);
        }

        public SemaphoreBlockingQueue() {
        }

        @Override
        public MarkedRunnable<T> take() throws InterruptedException {
            MarkedRunnable markedRunnable;
            do {
                if ((markedRunnable = (MarkedRunnable)super.take()) != null) continue;
                return null;
            } while (!this.checkConcurrency(markedRunnable));
            return markedRunnable;
        }

        @Override
        public MarkedRunnable<T> poll(long timeout, TimeUnit unit) throws InterruptedException {
            MarkedRunnable markedRunnable;
            do {
                if ((markedRunnable = (MarkedRunnable)super.poll(timeout, unit)) != null) continue;
                return null;
            } while (!this.checkConcurrency(markedRunnable));
            return markedRunnable;
        }

        @Override
        public boolean offer(MarkedRunnable<T> runnable) {
            if (this.remainingCapacity() <= 0) {
                return false;
            }
            return super.offer(runnable);
        }

        @Override
        public boolean offer(MarkedRunnable<T> runnable, long timeout, TimeUnit unit) throws InterruptedException {
            if (this.remainingCapacity() <= 0) {
                return false;
            }
            return super.offer(runnable, timeout, unit);
        }

        @Override
        public void put(MarkedRunnable<T> runnable) throws InterruptedException {
            super.put(runnable);
        }

        @Override
        public int size() {
            return super.size() + this.waitCount.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int remainingCapacity() {
            SemaphoreBlockingQueue semaphoreBlockingQueue = this;
            synchronized (semaphoreBlockingQueue) {
                return super.remainingCapacity() - this.waitCount.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkConcurrency(MarkedRunnable<T> markedRunnable) {
            T key = markedRunnable.identify();
            Semaphore semaphore = this.semaphoreMap.get(key);
            if (semaphore == null) {
                return true;
            }
            Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                if (!semaphore.tryAcquire()) {
                    Queue<MarkedRunnable<T>> waitQueue = this.waitQueueMap.get(key);
                    if (waitQueue == null) {
                        if (!this.semaphoreMap.containsKey(key)) {
                            return true;
                        }
                        waitQueue = new ConcurrentLinkedQueue<MarkedRunnable<T>>();
                        this.waitQueueMap.put(key, waitQueue);
                    }
                    if (waitQueue.offer(markedRunnable)) {
                        this.waitCount.incrementAndGet();
                        return false;
                    }
                    return true;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putSemaphore(T key, Integer concurrency) {
            Semaphore semaphore = this.semaphoreMap.get(key);
            if (semaphore == null) {
                Map<T, Semaphore> map2 = this.semaphoreMap;
                synchronized (map2) {
                    semaphore = this.semaphoreMap.get(key);
                    if (semaphore == null) {
                        this.semaphoreMap.put(key, new Semaphore(concurrency));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSemaphore(T key) {
            Semaphore semaphore = this.semaphoreMap.get(key);
            if (semaphore != null) {
                Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    MarkedRunnable<T> runnable;
                    semaphore.release();
                    Queue<MarkedRunnable<T>> waitQueue = this.waitQueueMap.get(key);
                    if (waitQueue != null && (runnable = waitQueue.poll()) != null) {
                        this.waitCount.decrementAndGet();
                        super.offer(runnable);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(T key) {
            Semaphore semaphore = this.semaphoreMap.remove(key);
            if (semaphore != null) {
                Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    Queue<MarkedRunnable<T>> waitQueue = this.waitQueueMap.remove(key);
                    if (waitQueue != null) {
                        this.waitCount.addAndGet(-1 * waitQueue.size());
                    }
                }
            } else {
                Queue<MarkedRunnable<T>> waitQueue = this.waitQueueMap.remove(key);
                if (waitQueue != null) {
                    this.waitCount.addAndGet(-1 * waitQueue.size());
                }
            }
        }

        @Override
        public void clear() {
            for (T key : this.semaphoreMap.keySet()) {
                this.clear(key);
            }
            super.clear();
        }
    }

    static class MarkedFutureTask<T>
    extends FutureTask
    implements MarkedRunnable<T> {
        private MarkedRunnable<T> runnable;

        public MarkedFutureTask(Callable callable) {
            super(callable);
            throw new IllegalArgumentException("can not support callable.");
        }

        public MarkedFutureTask(MarkedRunnable runnable, Object result2) {
            super(runnable, result2);
            this.runnable = runnable;
        }

        @Override
        public T identify() {
            return this.runnable.identify();
        }
    }
}

