/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.container;

import com.alibaba.schedulerx.common.domain.JobType;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.StringUtils;
import com.alibaba.schedulerx.shade.com.google.common.cache.Cache;
import com.alibaba.schedulerx.shade.com.google.common.cache.CacheBuilder;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.google.common.collect.Sets;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.MapUtils;
import com.alibaba.schedulerx.worker.container.Container;
import com.alibaba.schedulerx.worker.container.ContainerFactory;
import com.alibaba.schedulerx.worker.container.ContainerPool;
import com.alibaba.schedulerx.worker.container.DualConcurrencyThreadPoolExecutor;
import com.alibaba.schedulerx.worker.container.ShutdownMode;
import com.alibaba.schedulerx.worker.container.ThreadContainer;
import com.alibaba.schedulerx.worker.discovery.GroupManager;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.util.JobProcessorUtil;
import com.alibaba.schedulerx.worker.util.WorkerConfigUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadContainerPool
extends ContainerPool {
    private static ThreadContainerPool instance = new ThreadContainerPool();
    private Map<Long, ExecutorService> threadPoolMap = Maps.newConcurrentMap();
    private ThreadLocal<JobContext> contextThreadLocal = new ThreadLocal();
    private static DualConcurrencyThreadPoolExecutor<Long> SHARED_THREAD_POOL;
    private static final Map<Long, AtomicLong> jobInstanceLockMap;
    private Cache<String, ExecutorService> jobThreadPoolMap = CacheBuilder.newBuilder().expireAfterAccess(48L, TimeUnit.HOURS).build();

    private ThreadContainerPool() {
    }

    public static ThreadContainerPool getInstance() {
        return instance;
    }

    public ThreadPoolExecutor getSharedThreadPool() {
        return SHARED_THREAD_POOL;
    }

    private boolean executeInProcessorThreadPool(long jobInstanceId, Container container) {
        if (container instanceof ThreadContainer) {
            Integer size2;
            String processorName;
            ThreadContainer threadContainer = (ThreadContainer)container;
            Map processorThreadPoolSize = (Map)ConfigUtil.getWorkerConfig().getProperty("processor.thread.pool.size");
            if (processorThreadPoolSize == null || processorThreadPoolSize.size() == 0) {
                return false;
            }
            JobContext context = threadContainer.getContext();
            if (JobType.JAVA.getKey().equalsIgnoreCase(context.getJobType()) && StringUtils.isNotEmpty(processorName = JobProcessorUtil.getSimpleClassName(context.getContent())) && (size2 = (Integer)processorThreadPoolSize.get(processorName)) != null && size2 > 0) {
                this.executeInJobThreadPool(jobInstanceId, processorName, size2, container);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInJobThreadPool(long jobInstanceId, final String key, int poolSize, Container container) {
        if (this.jobThreadPoolMap.getIfPresent(key) == null) {
            ThreadContainerPool threadContainerPool = this;
            synchronized (threadContainerPool) {
                if (this.jobThreadPoolMap.getIfPresent(key) == null) {
                    poolSize = poolSize > 0 ? poolSize : 5;
                    ThreadPoolExecutor jobThreadPool = new ThreadPoolExecutor(poolSize, poolSize, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                        int index = 0;

                        @Override
                        public Thread newThread(Runnable runnable) {
                            return new Thread(runnable, "Schedulerx-Container-Thread-" + key + "-" + this.index++);
                        }
                    });
                    jobThreadPool.allowCoreThreadTimeOut(true);
                    this.jobThreadPoolMap.put(key, jobThreadPool);
                }
            }
        }
        Future<?> future2 = this.jobThreadPoolMap.getIfPresent(key).submit((Runnable)((Object)container));
        this.addFuture(container, jobInstanceId, future2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(final long jobId, final long jobInstanceId, long taskId, Container container, int consumerSize) {
        if (this.executeInProcessorThreadPool(jobInstanceId, container)) {
            return;
        }
        boolean enableShareContainerPool = WorkerConfigUtil.isEnableShareContainerPool();
        if (!enableShareContainerPool) {
            String mode = WorkerConfigUtil.getThreadPoolMode();
            if ("job".equals(mode)) {
                this.executeInJobThreadPool(jobInstanceId, Long.toString(jobId), consumerSize, container);
            } else {
                if (!this.threadPoolMap.containsKey(jobInstanceId)) {
                    ThreadContainerPool threadContainerPool = this;
                    synchronized (threadContainerPool) {
                        if (!this.threadPoolMap.containsKey(jobInstanceId)) {
                            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(consumerSize, consumerSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                                int index = 0;

                                @Override
                                public Thread newThread(Runnable runnable) {
                                    return new Thread(runnable, "Schedulerx-Container-Thread-" + jobId + "_" + jobInstanceId + "-" + this.index++);
                                }
                            });
                            this.threadPoolMap.put(jobInstanceId, threadPool);
                            threadPool.allowCoreThreadTimeOut(true);
                        }
                    }
                }
                Future<?> future2 = this.threadPoolMap.get(jobInstanceId).submit((Runnable)((Object)container));
                this.addFuture(container, jobInstanceId, future2);
            }
        } else {
            if (SHARED_THREAD_POOL == null) {
                ThreadContainerPool mode = this;
                synchronized (mode) {
                    if (SHARED_THREAD_POOL == null) {
                        int poolSize = ConfigUtil.getWorkerConfig().getInt("share.pool.size", 64);
                        int queueSize = ConfigUtil.getWorkerConfig().getInt("share.pool.queue.size", Integer.MAX_VALUE);
                        SHARED_THREAD_POOL = new DualConcurrencyThreadPoolExecutor(poolSize, queueSize, new ThreadFactory(){
                            int index = 0;

                            @Override
                            public Thread newThread(Runnable runnable) {
                                return new Thread(runnable, "Schedulerx-Shared-Container-Thread-" + this.index++);
                            }
                        });
                    }
                }
            }
            SHARED_THREAD_POOL.registerSemaphore(jobInstanceId, consumerSize);
            Future<?> future3 = SHARED_THREAD_POOL.submit((Runnable)((Object)container));
            this.addFuture(container, jobInstanceId, future3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFuture(Container container, long jobInstanceId, Future future2) {
        Set<Future> futureSet = (Set<Future>)this.futureMap.get(jobInstanceId);
        if (futureSet == null) {
            Map map2 = this.futureMap;
            synchronized (map2) {
                futureSet = (Set)this.futureMap.get(jobInstanceId);
                if (futureSet == null) {
                    futureSet = Sets.newConcurrentHashSet();
                    this.futureMap.put(jobInstanceId, futureSet);
                }
            }
        }
        if (container instanceof ThreadContainer) {
            ((ThreadContainer)container).setFuture(future2);
        }
        futureSet.add(future2);
    }

    @Override
    public synchronized boolean destroyByInstance(long jobInstanceId, boolean mayInterruptIfRunning) {
        if (this.threadPoolMap.containsKey(jobInstanceId)) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.threadPoolMap.get(jobInstanceId);
            if (mayInterruptIfRunning) {
                List<Runnable> runnableList = threadPoolExecutor.shutdownNow();
                if (CollectionUtils.isNotEmpty(runnableList)) {
                    for (Runnable runnable : runnableList) {
                        if (!(runnable instanceof ThreadContainer)) continue;
                        ContainerPool containerPool = ContainerFactory.getContainerPool();
                        String uniqueId = ((ThreadContainer)runnable).getContext().getUniqueId();
                        containerPool.remove(uniqueId);
                    }
                }
            } else {
                threadPoolExecutor.getQueue().clear();
                threadPoolExecutor.shutdown();
            }
            this.threadPoolMap.remove(jobInstanceId);
            this.futureMap.remove(jobInstanceId);
        } else if (this.futureMap.containsKey(jobInstanceId)) {
            for (Future future2 : (Set)this.futureMap.get(jobInstanceId)) {
                future2.cancel(mayInterruptIfRunning);
            }
            this.futureMap.remove(jobInstanceId);
        }
        if (SHARED_THREAD_POOL != null) {
            SHARED_THREAD_POOL.clear(jobInstanceId);
        }
        return super.destroyByInstance(jobInstanceId, mayInterruptIfRunning);
    }

    @Override
    public void setContext(JobContext jobContext) {
        this.contextThreadLocal.set(jobContext);
        boolean isAdvanced = GroupManager.INSTANCE.isAdvancedVersion(jobContext.getGroupId());
        if (isAdvanced) {
            this.record(jobContext.getJobId(), jobContext.getGroupId());
        }
    }

    @Override
    public JobContext getContext() {
        return this.contextThreadLocal.get();
    }

    @Override
    public void removeContext() {
        this.contextThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicLong getInstanceLock(long jobInstanceId, Long serialNum) {
        AtomicLong lock = jobInstanceLockMap.get(jobInstanceId);
        if (lock == null) {
            ThreadContainerPool threadContainerPool = this;
            synchronized (threadContainerPool) {
                lock = jobInstanceLockMap.get(jobInstanceId);
                if (lock == null) {
                    lock = new AtomicLong(serialNum == null ? 0L : serialNum);
                    jobInstanceLockMap.put(jobInstanceId, lock);
                }
            }
        }
        if (serialNum != null) {
            lock.set(serialNum);
        }
        return lock;
    }

    @Override
    public void releaseInstanceLock(long jobInstanceId) {
        jobInstanceLockMap.remove(jobInstanceId);
    }

    @Override
    public void shutdown(ShutdownMode mode) throws InterruptedException {
        HashSet<Object> services = Sets.newHashSet();
        if (MapUtils.isNotEmpty(this.jobThreadPoolMap.asMap())) {
            services.addAll(this.jobThreadPoolMap.asMap().values());
        }
        if (MapUtils.isNotEmpty(this.threadPoolMap)) {
            services.addAll(this.threadPoolMap.values());
        }
        if (SHARED_THREAD_POOL != null) {
            services.add(SHARED_THREAD_POOL);
        }
        if (ShutdownMode.WAIT_RUNNING.equals((Object)mode)) {
            for (ExecutorService executorService : services) {
                if (!(executorService instanceof ThreadPoolExecutor)) continue;
                ((ThreadPoolExecutor)executorService).getQueue().clear();
            }
        }
        for (ExecutorService executorService : services) {
            this.doShutdown(executorService, mode);
        }
        if (!ShutdownMode.IMMEDIATE.equals((Object)mode)) {
            for (ExecutorService executorService : services) {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
        }
    }

    private void doShutdown(ExecutorService executorService, ShutdownMode mode) {
        if (ShutdownMode.IMMEDIATE.equals((Object)mode)) {
            executorService.shutdownNow();
        } else {
            executorService.shutdown();
        }
    }

    @Override
    public String genThreadName(Long jobId, Long jobInstanceId, Long taskId) {
        String name = "Schedulerx-Container-Thread-" + jobId + "_" + jobInstanceId;
        if (taskId != null) {
            name = name + "_" + taskId;
        }
        return name;
    }

    public static void main(String[] args) {
        HashSet<ExecutorService> services = Sets.newHashSet();
        services.add(null);
        for (ExecutorService service : services) {
            service.shutdown();
        }
        System.out.println(services.size());
    }

    static {
        jobInstanceLockMap = Maps.newConcurrentMap();
    }
}

