/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.discovery;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.discovery.GroupDiscovery;
import java.util.ArrayList;
import java.util.List;

public class DefaultGroupDiscovery
implements GroupDiscovery {
    @Override
    public List<String> getGroupIdList(Configuration conf) throws Exception {
        String[] groupIds;
        ArrayList<String> groupIdList = Lists.newArrayList();
        String groupIdProperty = System.getProperty("schedulerx.groupId");
        if (StringUtils.isBlank(groupIdProperty)) {
            groupIdProperty = System.getenv("schedulerx.groupId".replace(".", "_"));
        }
        if (StringUtils.isNotBlank(groupIdProperty)) {
            conf.setProperty("groupId", groupIdProperty);
        }
        for (String groupId : groupIds = conf.getStringArray("groupId")) {
            String groupIdTrim = groupId.trim();
            if (groupIdList.contains(groupIdTrim)) continue;
            groupIdList.add(groupId.trim());
        }
        return groupIdList;
    }

    @Override
    public List<String> getAppKeyList(Configuration conf) throws Exception {
        String[] appKeys;
        ArrayList<String> appKeyList = Lists.newArrayList();
        String appKeyProperty = System.getProperty("schedulerx.appKey");
        if (StringUtils.isNotBlank(appKeyProperty)) {
            conf.setProperty("appKey", appKeyProperty);
        }
        for (String appKey : appKeys = conf.getStringArray("appKey")) {
            String appKeyTrim = appKey.trim();
            if (appKeyList.contains(appKeyTrim)) continue;
            appKeyList.add(appKeyTrim);
        }
        return appKeyList;
    }

    @Override
    public boolean isSystemProperty() {
        String appKeyProperty = System.getProperty("schedulerx.appKey");
        String groupIdProperty = System.getProperty("schedulerx.groupId");
        if (StringUtils.isBlank(groupIdProperty)) {
            groupIdProperty = System.getenv("schedulerx.groupId".replace(".", "_"));
        }
        return StringUtils.isNotBlank(appKeyProperty) || StringUtils.isNotBlank(groupIdProperty);
    }
}

