/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.log.appender;

import com.alibaba.schedulerx.common.domain.SlsInfo;
import com.alibaba.schedulerx.common.util.Base64Util;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Callback;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Producer;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.errors.TimeoutException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogItem;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.container.ContainerFactory;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.appender.LogConfig;
import com.alibaba.schedulerx.worker.log.appender.SchedulerxLog4j2AppenderCallback;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.status.StatusLogger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Plugin(name="SchedulerxLog4j2Appender", category="Core", elementType="appender", printObject=true)
public class SchedulerxLog4j2Appender
extends AbstractAppender {
    private static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DEFAULT_TIME_ZONE = "UTC";
    private String project;
    private String logStore;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String userAgent = "log4j2";
    private Producer producer;
    private String source;
    private ProducerConfig producerConfig = new ProducerConfig();
    private DateTimeFormatter formatter;
    private static final Logger logger = StatusLogger.getLogger();
    private LogCollector logCollector = LogCollectorFactory.get();

    protected SchedulerxLog4j2Appender(String name, Filter filter2, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter2, layout, ignoreExceptions);
    }

    public void start() {
        try {
            super.start();
            this.producerConfig.setMaxBlockMs(0L);
            this.producerConfig.setTotalSizeInBytes(0x1400000);
            ProjectConfig projectConfig = this.buildProjectConfig();
            if (projectConfig != null) {
                this.producer = new LogProducer(this.producerConfig);
                this.producer.putProjectConfig(projectConfig);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private ProjectConfig buildProjectConfig() {
        Configuration conf = ConfigUtil.getWorkerConfig();
        String logServiceType = conf.getString("log.collector.type", "default");
        if (logServiceType.equalsIgnoreCase("sls")) {
            Object logConfig = null;
            Object[] logConfigList = conf.getStringArray("log.service.config");
            if (logConfigList.length > 1) {
                logConfig = StringUtils.join(logConfigList, ",");
            } else if (logConfigList.length == 1) {
                logConfig = logConfigList[0];
            }
            if (StringUtils.isNotEmpty((String)logConfig) && !((String)logConfig).equalsIgnoreCase("null")) {
                SlsInfo slsInfo = JsonUtil.fromJson((String)logConfig, SlsInfo.class);
                this.endpoint = slsInfo.getEndpoint();
                this.project = slsInfo.getProject();
                this.logStore = slsInfo.getLogstore();
                if (conf.getBoolean("sls.aksk.encoded", false)) {
                    String encodedAccessKeyId = conf.getString("sls.ak");
                    this.accessKeyId = Base64Util.decode(encodedAccessKeyId);
                    String encodedAccessKeySecret = conf.getString("sls.sk");
                    this.accessKeySecret = Base64Util.decode(encodedAccessKeySecret);
                } else {
                    this.accessKeyId = conf.getString("sls.ak");
                    this.accessKeySecret = conf.getString("sls.sk");
                }
                if (this.project != null && this.logStore != null && this.endpoint != null && this.accessKeyId != null && this.accessKeySecret != null) {
                    LogConfig.INSTANCE.setEnable(true);
                    return new ProjectConfig(this.project, this.endpoint, this.accessKeyId, this.accessKeySecret);
                }
            }
        }
        return null;
    }

    public void stop() {
        super.stop();
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (Exception e) {
                logger.error("Failed to close LoghubAppender.", (Throwable)e);
            }
        }
    }

    public void append(LogEvent event) {
        ProjectConfig projectConfig;
        JobContext jobContext = ContainerFactory.getContainerPool().getContext();
        if (jobContext == null) {
            logger.warn("jobContext is null, threadName={}, stackTrace={}, message={}", (Object)event.getThreadName(), (Object)event.getSource(), (Object)event.getMessage().getFormattedMessage());
            return;
        }
        if (this.producer == null && (projectConfig = this.buildProjectConfig()) != null) {
            this.producer = new LogProducer(this.producerConfig);
            this.producer.putProjectConfig(projectConfig);
        }
        if (this.producer == null) {
            return;
        }
        if (!LogConfig.INSTANCE.isEnable()) {
            return;
        }
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        LogItem item = new LogItem();
        logItems.add(item);
        item.SetTime((int)(event.getTimeMillis() / 1000L));
        DateTime dateTime = new DateTime(event.getTimeMillis());
        item.PushBack("executionId", jobContext.getUniqueId());
        item.PushBack("time", dateTime.toString(this.formatter));
        item.PushBack("level", event.getLevel().toString());
        item.PushBack("thread", event.getThreadName());
        item.PushBack("group", "schedulerx-user");
        StackTraceElement source = event.getSource();
        if (source == null && !event.isIncludeLocation()) {
            event.setIncludeLocation(true);
            source = event.getSource();
            event.setIncludeLocation(false);
        }
        item.PushBack("location", source == null ? "Unknown(Unknown Source)" : source.toString());
        String message = event.getMessage().getFormattedMessage();
        item.PushBack("message", message);
        String throwable = this.getThrowableStr(event.getThrown());
        if (throwable != null) {
            item.PushBack("throwable", throwable);
        }
        if (this.getLayout() != null) {
            item.PushBack("log", new String(this.getLayout().toByteArray(event)));
        } else {
            item.PushBack("log", message);
        }
        String topic = this.createTopic(jobContext);
        try {
            this.producer.send(this.project, this.logStore, topic, this.source, logItems, (Callback)new SchedulerxLog4j2AppenderCallback(LOGGER, this.project, this.logStore, topic, this.source, logItems));
        }
        catch (TimeoutException e) {
            logger.error("send sls log timeout, threadName=" + event.getThreadName() + ", stackTrace=" + event.getSource());
        }
        catch (Exception e) {
            logger.error("Failed to send log, project=" + this.project + ", logStore=" + this.logStore + ", topic=" + topic + ", source=" + source + ", logItem=" + logItems, (Throwable)e);
        }
    }

    private String createTopic(JobContext jobContext) {
        return "group-" + jobContext.getAppGroupId();
    }

    private String getThrowableStr(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String s2 : Throwables.toStringList((Throwable)throwable)) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    @PluginFactory
    public static SchedulerxLog4j2Appender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter2, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginConfiguration Configuration config, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginAttribute(value="project") String project, @PluginAttribute(value="logStore") String logStore, @PluginAttribute(value="endpoint") String endpoint, @PluginAttribute(value="accessKeyId") String accessKeyId, @PluginAttribute(value="accessKeySecret") String accessKeySecret, @PluginAttribute(value="stsToken") String stsToken, @PluginAttribute(value="totalSizeInBytes") String totalSizeInBytes, @PluginAttribute(value="maxBlockMs") String maxBlockMs, @PluginAttribute(value="ioThreadCount") String ioThreadCount, @PluginAttribute(value="batchSizeThresholdInBytes") String batchSizeThresholdInBytes, @PluginAttribute(value="batchCountThreshold") String batchCountThreshold, @PluginAttribute(value="lingerMs") String lingerMs, @PluginAttribute(value="retries") String retries, @PluginAttribute(value="baseRetryBackoffMs") String baseRetryBackoffMs, @PluginAttribute(value="maxRetryBackoffMs") String maxRetryBackoffMs, @PluginAttribute(value="topic") String topic, @PluginAttribute(value="source") String source, @PluginAttribute(value="timeFormat") String timeFormat, @PluginAttribute(value="timeZone") String timeZone, @PluginAttribute(value="mdcFields") String mdcFields) {
        Boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        int maxBlockMsInt = SchedulerxLog4j2Appender.parseStrToInt(maxBlockMs, 0);
        int baseRetryBackoffMsInt = SchedulerxLog4j2Appender.parseStrToInt(baseRetryBackoffMs, 100);
        int maxRetryBackoffMsInt = SchedulerxLog4j2Appender.parseStrToInt(maxRetryBackoffMs, 100);
        int lingerMsInt = SchedulerxLog4j2Appender.parseStrToInt(lingerMs, 3000);
        int batchCountThresholdInt = SchedulerxLog4j2Appender.parseStrToInt(batchCountThreshold, 4096);
        int batchSizeThresholdInBytesInt = SchedulerxLog4j2Appender.parseStrToInt(batchSizeThresholdInBytes, 0x500000);
        int totalSizeInBytesInt = SchedulerxLog4j2Appender.parseStrToInt(totalSizeInBytes, 0xA00000);
        int retriesInt = SchedulerxLog4j2Appender.parseStrToInt(retries, 3);
        int ioThreadCountInt = SchedulerxLog4j2Appender.parseStrToInt(ioThreadCount, 8);
        String pattern = SchedulerxLog4j2Appender.isStrEmpty(timeFormat) ? DEFAULT_TIME_FORMAT : timeFormat;
        String timeZoneInfo = SchedulerxLog4j2Appender.isStrEmpty(timeZone) ? DEFAULT_TIME_ZONE : timeZone;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withZone(DateTimeZone.forID((String)timeZoneInfo));
        return new SchedulerxLog4j2Appender(name, filter2, layout, ignoreExceptions);
    }

    static boolean isStrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static int parseStrToInt(String str, int defaultVal) {
        if (!SchedulerxLog4j2Appender.isStrEmpty(str)) {
            try {
                return Integer.valueOf(str);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    static void checkCondition(Boolean condition, String errorMsg) {
        if (!condition.booleanValue()) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getLogStore() {
        return this.logStore;
    }

    public void setLogStore(String logStore) {
        this.logStore = logStore;
    }

    public int getTotalSizeInBytes() {
        return this.producerConfig.getTotalSizeInBytes();
    }

    public void setTotalSizeInBytes(int totalSizeInBytes) {
        this.producerConfig.setTotalSizeInBytes(totalSizeInBytes);
    }

    public long getMaxBlockMs() {
        return this.producerConfig.getMaxBlockMs();
    }

    public void setMaxBlockMs(long maxBlockMs) {
        this.producerConfig.setMaxBlockMs(maxBlockMs);
    }

    public int getIoThreadCount() {
        return this.producerConfig.getIoThreadCount();
    }

    public void setIoThreadCount(int ioThreadCount) {
        this.producerConfig.setIoThreadCount(ioThreadCount);
    }

    public int getBatchSizeThresholdInBytes() {
        return this.producerConfig.getBatchSizeThresholdInBytes();
    }

    public void setBatchSizeThresholdInBytes(int batchSizeThresholdInBytes) {
        this.producerConfig.setBatchSizeThresholdInBytes(batchSizeThresholdInBytes);
    }

    public int getBatchCountThreshold() {
        return this.producerConfig.getBatchCountThreshold();
    }

    public void setBatchCountThreshold(int batchCountThreshold) {
        this.producerConfig.setBatchCountThreshold(batchCountThreshold);
    }

    public int getLingerMs() {
        return this.producerConfig.getLingerMs();
    }

    public void setLingerMs(int lingerMs) {
        this.producerConfig.setLingerMs(lingerMs);
    }

    public int getRetries() {
        return this.producerConfig.getRetries();
    }

    public void setRetries(int retries) {
        this.producerConfig.setRetries(retries);
    }

    public int getMaxReservedAttempts() {
        return this.producerConfig.getMaxReservedAttempts();
    }

    public void setMaxReservedAttempts(int maxReservedAttempts) {
        this.producerConfig.setMaxReservedAttempts(maxReservedAttempts);
    }

    public long getBaseRetryBackoffMs() {
        return this.producerConfig.getBaseRetryBackoffMs();
    }

    public void setBaseRetryBackoffMs(long baseRetryBackoffMs) {
        this.producerConfig.setBaseRetryBackoffMs(baseRetryBackoffMs);
    }

    public long getMaxRetryBackoffMs() {
        return this.producerConfig.getMaxRetryBackoffMs();
    }

    public void setMaxRetryBackoffMs(long maxRetryBackoffMs) {
        this.producerConfig.setMaxRetryBackoffMs(maxRetryBackoffMs);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

