/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.log.appender;

import com.alibaba.schedulerx.common.domain.SlsInfo;
import com.alibaba.schedulerx.common.util.Base64Util;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Callback;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Producer;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogItem;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.container.ContainerFactory;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.appender.LogConfig;
import com.alibaba.schedulerx.worker.log.appender.SchedulerxLog4jAppenderCallback;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SchedulerxLog4jAppender
extends AppenderSkeleton {
    private String project;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String userAgent = "log4j";
    private String logStore;
    private ProducerConfig producerConfig = new ProducerConfig();
    private String source = "";
    private String timeFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
    private String timeZone = "UTC";
    private Producer producer;
    private DateTimeFormatter formatter;
    private LogCollector logCollector = LogCollectorFactory.get();

    public void activateOptions() {
        try {
            super.activateOptions();
            this.formatter = DateTimeFormat.forPattern((String)this.timeFormat).withZone(DateTimeZone.forID((String)this.timeZone));
            this.producerConfig.setMaxBlockMs(0L);
            this.producerConfig.setTotalSizeInBytes(0x1400000);
            ProjectConfig projectConfig = this.buildProjectConfig();
            if (projectConfig != null) {
                this.producer = new LogProducer(this.producerConfig);
                this.producer.putProjectConfig(projectConfig);
            }
        }
        catch (Exception e) {
            LogLog.error((String)"", (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    SchedulerxLog4jAppender.this.doClose();
                }
                catch (Exception e) {
                    LogLog.error((String)"Failed to close LoghubAppender.", (Throwable)e);
                }
            }
        });
    }

    public void close() {
        try {
            this.doClose();
        }
        catch (Exception e) {
            LogLog.error((String)"Failed to close LoghubAppender.", (Throwable)e);
        }
    }

    private void doClose() throws InterruptedException, ProducerException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    private ProjectConfig buildProjectConfig() {
        Configuration conf = ConfigUtil.getWorkerConfig();
        String logServiceType = conf.getString("log.collector.type", "default");
        if (logServiceType.equalsIgnoreCase("sls")) {
            Object logConfig = null;
            Object[] logConfigList = conf.getStringArray("log.service.config");
            if (logConfigList.length > 1) {
                logConfig = StringUtils.join(logConfigList, ",");
            } else if (logConfigList.length == 1) {
                logConfig = logConfigList[0];
            }
            if (StringUtils.isNotEmpty((String)logConfig) && !((String)logConfig).equalsIgnoreCase("null")) {
                SlsInfo slsInfo = JsonUtil.fromJson((String)logConfig, SlsInfo.class);
                this.endpoint = slsInfo.getEndpoint();
                this.project = slsInfo.getProject();
                this.logStore = slsInfo.getLogstore();
                if (conf.getBoolean("sls.aksk.encoded", false)) {
                    String encodedAccessKeyId = conf.getString("sls.ak");
                    this.accessKeyId = Base64Util.decode(encodedAccessKeyId);
                    String encodedAccessKeySecret = conf.getString("sls.sk");
                    this.accessKeySecret = Base64Util.decode(encodedAccessKeySecret);
                } else {
                    this.accessKeyId = conf.getString("sls.ak");
                    this.accessKeySecret = conf.getString("sls.sk");
                }
                if (this.project != null && this.logStore != null && this.endpoint != null && this.accessKeyId != null && this.accessKeySecret != null) {
                    LogConfig.INSTANCE.setEnable(true);
                    return new ProjectConfig(this.project, this.endpoint, this.accessKeyId, this.accessKeySecret);
                }
            }
        }
        return null;
    }

    protected void append(LoggingEvent event) {
        ProjectConfig projectConfig;
        JobContext jobContext = ContainerFactory.getContainerPool().getContext();
        if (jobContext == null) {
            LogLog.warn((String)("jobContext is null, threadName=" + event.getThreadName() + ", message=" + event.getMessage().toString()));
            return;
        }
        if (this.producer == null && (projectConfig = this.buildProjectConfig()) != null) {
            this.producer = new LogProducer(this.producerConfig);
            this.producer.putProjectConfig(projectConfig);
        }
        if (this.producer == null) {
            return;
        }
        if (!LogConfig.INSTANCE.isEnable()) {
            return;
        }
        LogItem logItem = new LogItem();
        logItem.SetTime((int)(event.getTimeStamp() / 1000L));
        DateTime dateTime = new DateTime(event.getTimeStamp());
        logItem.PushBack("executionId", jobContext.getUniqueId());
        logItem.PushBack("time", dateTime.toString(this.formatter));
        logItem.PushBack("level", event.getLevel().toString());
        logItem.PushBack("thread", event.getThreadName());
        logItem.PushBack("location", event.getLocationInformation().fullInfo);
        Object message = event.getMessage();
        if (message == null) {
            logItem.PushBack("message", "");
        } else {
            logItem.PushBack("message", event.getMessage().toString());
        }
        String throwable = this.getThrowableStr(event);
        if (throwable != null) {
            logItem.PushBack("throwable", throwable);
        }
        if (this.getLayout() != null) {
            logItem.PushBack("log", this.getLayout().format(event));
        } else {
            logItem.PushBack("log", event.getMessage().toString());
        }
        Map properties = event.getProperties();
        if (properties.size() > 0) {
            Object[] keys = properties.keySet().toArray();
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                logItem.PushBack(keys[i].toString(), properties.get(keys[i]).toString());
            }
        }
        String topic = this.createTopic(jobContext);
        try {
            this.producer.send(this.project, this.logStore, topic, this.source, logItem, (Callback)new SchedulerxLog4jAppenderCallback(this.project, this.logStore, topic, this.source, logItem));
        }
        catch (Exception e) {
            LogLog.error((String)("Failed to send log, project=" + this.project + ", logStore=" + this.logStore + ", topic=" + topic + ", source=" + this.source + ", logItem=" + logItem), (Throwable)e);
        }
    }

    private String createTopic(JobContext jobContext) {
        return "group-" + jobContext.getAppGroupId();
    }

    private String getThrowableStr(LoggingEvent event) {
        ThrowableInformation throwable = event.getThrowableInformation();
        if (throwable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String s2 : throwable.getThrowableStrRep()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getLogStore() {
        return this.logStore;
    }

    public void setLogStore(String logStore) {
        this.logStore = logStore;
    }

    public int getTotalSizeInBytes() {
        return this.producerConfig.getTotalSizeInBytes();
    }

    public void setTotalSizeInBytes(int totalSizeInBytes) {
        this.producerConfig.setTotalSizeInBytes(totalSizeInBytes);
    }

    public long getMaxBlockMs() {
        return this.producerConfig.getMaxBlockMs();
    }

    public void setMaxBlockMs(long maxBlockMs) {
        this.producerConfig.setMaxBlockMs(maxBlockMs);
    }

    public int getIoThreadCount() {
        return this.producerConfig.getIoThreadCount();
    }

    public void setIoThreadCount(int ioThreadCount) {
        this.producerConfig.setIoThreadCount(ioThreadCount);
    }

    public int getBatchSizeThresholdInBytes() {
        return this.producerConfig.getBatchSizeThresholdInBytes();
    }

    public void setBatchSizeThresholdInBytes(int batchSizeThresholdInBytes) {
        this.producerConfig.setBatchSizeThresholdInBytes(batchSizeThresholdInBytes);
    }

    public int getBatchCountThreshold() {
        return this.producerConfig.getBatchCountThreshold();
    }

    public void setBatchCountThreshold(int batchCountThreshold) {
        this.producerConfig.setBatchCountThreshold(batchCountThreshold);
    }

    public int getLingerMs() {
        return this.producerConfig.getLingerMs();
    }

    public void setLingerMs(int lingerMs) {
        this.producerConfig.setLingerMs(lingerMs);
    }

    public int getRetries() {
        return this.producerConfig.getRetries();
    }

    public void setRetries(int retries) {
        this.producerConfig.setRetries(retries);
    }

    public int getMaxReservedAttempts() {
        return this.producerConfig.getMaxReservedAttempts();
    }

    public void setMaxReservedAttempts(int maxReservedAttempts) {
        this.producerConfig.setMaxReservedAttempts(maxReservedAttempts);
    }

    public long getBaseRetryBackoffMs() {
        return this.producerConfig.getBaseRetryBackoffMs();
    }

    public void setBaseRetryBackoffMs(long baseRetryBackoffMs) {
        this.producerConfig.setBaseRetryBackoffMs(baseRetryBackoffMs);
    }

    public long getMaxRetryBackoffMs() {
        return this.producerConfig.getMaxRetryBackoffMs();
    }

    public void setMaxRetryBackoffMs(long maxRetryBackoffMs) {
        this.producerConfig.setMaxRetryBackoffMs(maxRetryBackoffMs);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }
}

