/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.log.appender;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import com.alibaba.schedulerx.common.domain.SlsInfo;
import com.alibaba.schedulerx.common.util.Base64Util;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Producer;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.errors.TimeoutException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogItem;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.container.ContainerFactory;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.appender.LogConfig;
import com.alibaba.schedulerx.worker.log.appender.SchedulerxLogbackAppenderCallBack;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SchedulerxLogbackAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private String project;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String userAgent = "logback";
    protected Encoder<E> encoder;
    protected ProducerConfig producerConfig = new ProducerConfig();
    protected Producer producer;
    protected String logStore;
    protected String topic = "";
    protected String source = "";
    protected String timeZone = "UTC";
    protected String timeFormat = "yyyy-MM-dd'T'HH:mmZ";
    protected DateTimeFormatter formatter;
    protected java.time.format.DateTimeFormatter formatter1;
    private LogCollector logCollector = LogCollectorFactory.get();

    public void start() {
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.addError("Failed to start SchedulerxLogbackAppender.", e);
        }
    }

    private void doStart() {
        try {
            this.formatter = DateTimeFormat.forPattern((String)this.timeFormat).withZone(DateTimeZone.forID((String)this.timeZone));
        }
        catch (Exception e) {
            this.formatter1 = java.time.format.DateTimeFormatter.ofPattern(this.timeFormat).withZone(ZoneId.of(this.timeZone));
        }
        super.start();
        this.producerConfig.setMaxBlockMs(0L);
        this.producerConfig.setTotalSizeInBytes(0x1400000);
        ProjectConfig projectConfig = this.buildProjectConfig();
        if (projectConfig != null) {
            this.producer = new LogProducer(this.producerConfig);
            this.producer.putProjectConfig(projectConfig);
        }
    }

    private ProjectConfig buildProjectConfig() {
        Configuration conf = ConfigUtil.getWorkerConfig();
        String logServiceType = conf.getString("log.collector.type", "default");
        if (logServiceType.equalsIgnoreCase("sls")) {
            Object logConfig = null;
            Object[] logConfigList = conf.getStringArray("log.service.config");
            if (logConfigList.length > 1) {
                logConfig = StringUtils.join(logConfigList, ",");
            } else if (logConfigList.length == 1) {
                logConfig = logConfigList[0];
            }
            if (StringUtils.isNotEmpty((String)logConfig) && !((String)logConfig).equalsIgnoreCase("null")) {
                SlsInfo slsInfo = JsonUtil.fromJson((String)logConfig, SlsInfo.class);
                this.endpoint = slsInfo.getEndpoint();
                this.project = slsInfo.getProject();
                this.logStore = slsInfo.getLogstore();
                if (conf.getBoolean("sls.aksk.encoded", false)) {
                    String encodedAccessKeyId = conf.getString("sls.ak");
                    this.accessKeyId = Base64Util.decode(encodedAccessKeyId);
                    String encodedAccessKeySecret = conf.getString("sls.sk");
                    this.accessKeySecret = Base64Util.decode(encodedAccessKeySecret);
                } else {
                    this.accessKeyId = conf.getString("sls.ak");
                    this.accessKeySecret = conf.getString("sls.sk");
                }
                if (this.project != null && this.logStore != null && this.endpoint != null && this.accessKeyId != null && this.accessKeySecret != null) {
                    LogConfig.INSTANCE.setEnable(true);
                    return new ProjectConfig(this.project, this.endpoint, this.accessKeyId, this.accessKeySecret);
                }
            }
        }
        return null;
    }

    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            this.addError("Failed to stop SchedulerxLogbackAppender.", e);
        }
    }

    private void doStop() throws InterruptedException, ProducerException {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public void append(E eventObject) {
        try {
            this.appendEvent(eventObject);
        }
        catch (Exception e) {
            this.addError("Failed to append event.", e);
        }
    }

    private void appendEvent(E eventObject) {
        ProjectConfig projectConfig;
        if (!(eventObject instanceof LoggingEvent)) {
            return;
        }
        LoggingEvent event = (LoggingEvent)eventObject;
        JobContext jobContext = ContainerFactory.getContainerPool().getContext();
        if (jobContext == null) {
            this.addWarn("jobContext is null, threadName=" + event.getThreadName() + ", stackTrace=" + event.getCallerData() + ", message=" + event.getFormattedMessage());
            return;
        }
        if (this.producer == null && (projectConfig = this.buildProjectConfig()) != null) {
            this.producer = new LogProducer(this.producerConfig);
            this.producer.putProjectConfig(projectConfig);
        }
        if (this.producer == null) {
            return;
        }
        if (!LogConfig.INSTANCE.isEnable()) {
            return;
        }
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        LogItem item = new LogItem();
        logItems.add(item);
        item.SetTime((int)(event.getTimeStamp() / 1000L));
        item.PushBack("executionId", jobContext.getUniqueId());
        if (this.formatter != null) {
            DateTime dateTime = new DateTime(event.getTimeStamp());
            item.PushBack("time", dateTime.toString(this.formatter));
        } else {
            Instant instant = Instant.ofEpochMilli(event.getTimeStamp());
            item.PushBack("time", this.formatter1.format(instant));
        }
        item.PushBack("level", event.getLevel().toString());
        item.PushBack("thread", event.getThreadName());
        item.PushBack("group", "schedulerx-user");
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            item.PushBack("location", caller[0].toString());
        }
        String message = event.getFormattedMessage();
        item.PushBack("message", message);
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            String throwable = this.getExceptionInfo(iThrowableProxy);
            throwable = throwable + this.fullDump(event.getThrowableProxy().getStackTraceElementProxyArray());
            item.PushBack("throwable", throwable);
        }
        if (this.encoder != null) {
            item.PushBack("log", new String(this.encoder.encode(eventObject)));
        } else {
            item.PushBack("log", message);
        }
        try {
            String topic = this.createTopic(jobContext);
            this.producer.send(this.project, this.logStore, topic, this.source, logItems, new SchedulerxLogbackAppenderCallBack(this, this.project, this.logStore, topic, this.source, logItems));
        }
        catch (TimeoutException e) {
            this.addError("send sls log timeout, threadName=" + event.getThreadName() + ", stackTrace=" + event.getCallerData());
        }
        catch (Exception e) {
            this.addError("Failed to send log.", e);
        }
    }

    private String createTopic(JobContext jobContext) {
        return "group-" + jobContext.getAppGroupId();
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    private String getExceptionInfo(IThrowableProxy iThrowableProxy) {
        String s2 = iThrowableProxy.getClassName();
        String message = iThrowableProxy.getMessage();
        return message != null ? s2 + ": " + message : s2;
    }

    private String fullDump(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : stackTraceElementProxyArray) {
            builder.append(CoreConstants.LINE_SEPARATOR);
            String string2 = step.toString();
            builder.append('\t').append(string2);
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
        }
        return builder.toString();
    }

    public String getLogStore() {
        return this.logStore;
    }

    public void setLogStore(String logStore) {
        this.logStore = logStore;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public int getTotalSizeInBytes() {
        return this.producerConfig.getTotalSizeInBytes();
    }

    public void setTotalSizeInBytes(int totalSizeInBytes) {
        this.producerConfig.setTotalSizeInBytes(totalSizeInBytes);
    }

    public long getMaxBlockMs() {
        return this.producerConfig.getMaxBlockMs();
    }

    public void setMaxBlockMs(long maxBlockMs) {
        this.producerConfig.setMaxBlockMs(maxBlockMs);
    }

    public int getIoThreadCount() {
        return this.producerConfig.getIoThreadCount();
    }

    public void setIoThreadCount(int ioThreadCount) {
        this.producerConfig.setIoThreadCount(ioThreadCount);
    }

    public int getBatchSizeThresholdInBytes() {
        return this.producerConfig.getBatchSizeThresholdInBytes();
    }

    public void setBatchSizeThresholdInBytes(int batchSizeThresholdInBytes) {
        this.producerConfig.setBatchSizeThresholdInBytes(batchSizeThresholdInBytes);
    }

    public int getBatchCountThreshold() {
        return this.producerConfig.getBatchCountThreshold();
    }

    public void setBatchCountThreshold(int batchCountThreshold) {
        this.producerConfig.setBatchCountThreshold(batchCountThreshold);
    }

    public int getLingerMs() {
        return this.producerConfig.getLingerMs();
    }

    public void setLingerMs(int lingerMs) {
        this.producerConfig.setLingerMs(lingerMs);
    }

    public int getRetries() {
        return this.producerConfig.getRetries();
    }

    public void setRetries(int retries) {
        this.producerConfig.setRetries(retries);
    }

    public int getMaxReservedAttempts() {
        return this.producerConfig.getMaxReservedAttempts();
    }

    public void setMaxReservedAttempts(int maxReservedAttempts) {
        this.producerConfig.setMaxReservedAttempts(maxReservedAttempts);
    }

    public long getBaseRetryBackoffMs() {
        return this.producerConfig.getBaseRetryBackoffMs();
    }

    public void setBaseRetryBackoffMs(long baseRetryBackoffMs) {
        this.producerConfig.setBaseRetryBackoffMs(baseRetryBackoffMs);
    }

    public long getMaxRetryBackoffMs() {
        return this.producerConfig.getMaxRetryBackoffMs();
    }

    public void setMaxRetryBackoffMs(long maxRetryBackoffMs) {
        this.producerConfig.setMaxRetryBackoffMs(maxRetryBackoffMs);
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

