/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import akka.actor.ActorSelection;
import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.domain.TimeType;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.common.util.JobUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.protocol.utils.FutureUtils;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.domain.JavaProcessorProfile;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.ClientLoggerMessage;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.processor.MapJobProcessor;
import com.alibaba.schedulerx.worker.route.Router;
import com.alibaba.schedulerx.worker.route.RouterFactory;
import com.alibaba.schedulerx.worker.util.ActorPathUtil;
import com.alibaba.schedulerx.worker.util.JobProcessorUtil;
import com.alibaba.schedulerx.worker.util.WorkerIdGenerator;
import java.io.IOException;
import java.util.List;

public class StandaloneTaskMaster
extends TaskMaster {
    private LogCollector logCollector = LogCollectorFactory.get();
    private static final Logger LOGGER = LogFactory.getLogger(StandaloneTaskMaster.class);
    private ActorSelection currentSelection = this.getActorContext().actorSelection(this.getLocalContainerRouterPath());
    private String currentWorkerAddr = this.getLocalWorkerIdAddr();

    public StandaloneTaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
    }

    @Override
    public synchronized void submitInstance(JobInstanceInfo info) {
        long taskId = this.aquireTaskId();
        String uniqueId = IdUtil.getUniqueId(info.getJobId(), info.getJobInstanceId(), taskId);
        Worker.MasterStartContainerRequest.Builder builder = this.convert2StartContainerRequestBuilder(info, taskId);
        Worker.MasterStartContainerRequest request = builder.build();
        try {
            Worker.MasterStartContainerResponse response;
            Boolean dispatch = ConfigUtil.getWorkerConfig().getBoolean("second_delay.standalone.dispatch", false);
            if (JobUtil.isSecondTypeJob(TimeType.parseValue(this.jobInstanceInfo.getTimeType())) && dispatch.booleanValue()) {
                this.currentWorkerAddr = this.selectWorker();
                this.currentSelection = this.getActorContext().actorSelection(ActorPathUtil.getContainerRouterPath(this.selectWorker()));
            }
            if (!(response = (Worker.MasterStartContainerResponse)FutureUtils.awaitResult(this.currentSelection, (Object)request, 10L)).getSuccess()) {
                LOGGER.error("submitTask error.", response.getMessage());
                this.taskStatusMap.put(uniqueId, TaskStatus.FAILED);
                this.logCollector.collect(this.jobInstanceInfo.getAppGroupId(), uniqueId, ClientLoggerMessage.appendMessage("standalone taskMaster init fail:", response.getMessage()));
                Worker.ContainerReportTaskStatusRequest faileRequest = Worker.ContainerReportTaskStatusRequest.newBuilder().setJobId(info.getJobId()).setJobInstanceId(info.getJobInstanceId()).setTaskId(taskId).setStatus(TaskStatus.FAILED.getValue()).setResult("Start container request failed: " + response.getMessage()).setWorkerId(WorkerIdGenerator.get()).setWorkerAddr(SchedulerxWorker.WORKER_ADDR).setSerialNum(this.getSerialNum()).build();
                this.updateTaskStatus(faileRequest);
                return;
            }
            this.taskStatusMap.put(uniqueId, TaskStatus.INIT);
            this.init();
        }
        catch (Throwable e) {
            LOGGER.error("submitTask error.", e);
            this.logCollector.collect(this.jobInstanceInfo.getAppGroupId(), uniqueId, "standalone taskMaster init fail:", e);
            this.taskStatusMap.put(uniqueId, TaskStatus.FAILED);
            Worker.ContainerReportTaskStatusRequest faileRequest = Worker.ContainerReportTaskStatusRequest.newBuilder().setJobId(info.getJobId()).setJobInstanceId(info.getJobInstanceId()).setTaskId(taskId).setStatus(TaskStatus.FAILED.getValue()).setResult("SubmitTask error. " + e.getMessage()).setWorkerId(WorkerIdGenerator.get()).setWorkerAddr(SchedulerxWorker.WORKER_ADDR).setSerialNum(this.getSerialNum()).build();
            this.updateTaskStatus(faileRequest);
        }
    }

    protected String selectWorker() {
        String workerAddr = null;
        if (this.jobInstanceInfo.getRouteStrategyType() == null || this.jobInstanceInfo.getRouteStrategyContent() == null || this.jobInstanceInfo.getTargetWorkerAddrsMap() == null) {
            List<String> allWorkers = this.jobInstanceInfo.getAllWorkers();
            int size2 = allWorkers.size();
            int index = 0;
            if (size2 == 0) {
                return null;
            }
            if (this.getSerialNum() >= (long)size2) {
                index = new Long(this.getSerialNum() % (long)size2).intValue();
            }
            workerAddr = allWorkers.get(index);
        } else {
            Router router = RouterFactory.getRouter(this.jobInstanceInfo.getAppGroupId(), this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getRouteStrategyType(), this.jobInstanceInfo.getRouteStrategyContent());
            workerAddr = router.route(this.jobInstanceInfo.getAppGroupId(), this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getAllWorkers(), this.jobInstanceInfo.getTargetWorkerAddrsMap(), this.getSerialNum(), this.getLocalWorkerIdAddr());
        }
        LOGGER.info("dispatcher workerAddr is " + workerAddr);
        return workerAddr;
    }

    @Override
    public synchronized void killInstance(boolean mayInterruptIfRunning, String reason) {
        super.killInstance(mayInterruptIfRunning, reason);
        this.sendKillContainerRequest(mayInterruptIfRunning, Lists.newArrayList(this.currentWorkerAddr));
        this.updateNewInstanceStatus(this.getSerialNum(), this.jobInstanceInfo.getJobInstanceId(), InstanceStatus.FAILED, reason);
        if (!this.instanceStatus.isFinish()) {
            this.instanceStatus = InstanceStatus.FAILED;
        }
    }

    @Override
    public synchronized void destroyContainerPool() {
        try {
            Worker.MasterDestroyContainerPoolRequest request = Worker.MasterDestroyContainerPoolRequest.newBuilder().setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setSerialNum(this.getSerialNum()).build();
            FutureUtils.awaitResult(this.currentSelection, (Object)request, 5L);
        }
        catch (Throwable e) {
            LOGGER.error("destroy containerPool failed", e);
        }
    }

    @Override
    protected void checkProcessor() throws Exception {
        JavaProcessorProfile profile;
        if ("java".equalsIgnoreCase(this.jobInstanceInfo.getJobType()) && JobProcessorUtil.checkJavaProcessor((profile = JsonUtil.fromJson(this.jobInstanceInfo.getContent(), JavaProcessorProfile.class)).getClassName(), MapJobProcessor.class).booleanValue()) {
            throw new IOException(profile.getClassName() + " shouldn't extends MapJobProcessor or MapReduceJobProcessor");
        }
    }

    public ActorSelection getCurrentSelection() {
        return this.currentSelection;
    }
}

