/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public enum TaskMasterPool {
    INSTANCE;

    private Map<Long, TaskMaster> masterPool = Maps.newConcurrentMap();

    public TaskMaster get(long jobInstanceId) {
        return this.masterPool.get(jobInstanceId);
    }

    public void put(long jobInstanceId, TaskMaster taskMaster) {
        this.masterPool.put(jobInstanceId, taskMaster);
    }

    public void remove(long jobInstanceId) {
        TaskMaster taskMaster = this.masterPool.remove(jobInstanceId);
        if (taskMaster != null) {
            taskMaster.latchRelease();
        }
    }

    public boolean contains(long jobInstanceId) {
        return this.masterPool.containsKey(jobInstanceId);
    }

    public List<Long> getInstanceIds(long appGroupId) {
        ArrayList<Long> list = Lists.newArrayList();
        for (TaskMaster taskMaster : this.getAllTaskMaster()) {
            if (taskMaster.getJobInstanceInfo().getAppGroupId() != appGroupId) continue;
            list.add(taskMaster.getJobInstanceInfo().getJobInstanceId());
        }
        return list;
    }

    public void clear() {
        this.masterPool.clear();
    }

    public Collection<TaskMaster> getAllTaskMaster() {
        return this.masterPool.values();
    }
}

