/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.scheduler;

import com.alibaba.schedulerx.shade.com.google.common.collect.Sets;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.scheduler.TimePlanEntry;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;

public class TimeQueue {
    private Queue<TimePlanEntry> timeQueue = new PriorityBlockingQueue<TimePlanEntry>(100, new Comparator<TimePlanEntry>(){

        @Override
        public int compare(TimePlanEntry o1, TimePlanEntry o2) {
            return (int)(o1.getScheduleTimeStamp() - o2.getScheduleTimeStamp());
        }
    });
    private Set<TimePlanEntry> timeSet = Sets.newConcurrentHashSet();
    private static final Logger LOGGER = LogFactory.getLogger(TimeQueue.class);

    public void add(TimePlanEntry timePlanEntry) {
        if (!this.timeSet.contains(timePlanEntry)) {
            if (this.timeSet.add(timePlanEntry)) {
                this.timeQueue.add(timePlanEntry);
                LOGGER.info("timeQueue add plan={}", timePlanEntry);
            } else {
                LOGGER.warn("plan={} is existed in timeQueue", timePlanEntry);
            }
        } else {
            LOGGER.warn("plan={} is existed in timeQueue", timePlanEntry);
        }
    }

    public void remove(long jobInstanceId) {
        Iterator it = this.timeQueue.iterator();
        while (it.hasNext()) {
            TimePlanEntry planEntry = (TimePlanEntry)it.next();
            if (planEntry.getJobInstanceId() != jobInstanceId) continue;
            it.remove();
            this.timeSet.remove(planEntry);
            LOGGER.info("planEntry={} removed, event.getTriggerType()!=null", planEntry);
        }
    }

    public TimePlanEntry peek() {
        return this.timeQueue.peek();
    }

    public TimePlanEntry remove() {
        TimePlanEntry planEntry = this.timeQueue.remove();
        this.timeSet.remove(planEntry);
        return planEntry;
    }

    public boolean isEmpty() {
        return this.timeQueue.isEmpty();
    }

    public int size() {
        return this.timeQueue.size();
    }

    public void clear() {
        this.timeQueue.clear();
        this.timeSet.clear();
    }
}

