/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.scheduler;

import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.scheduler.TimePlanEntry;
import com.alibaba.schedulerx.worker.master.scheduler.TimeQueue;

public enum TimeScheduler {
    INSTANCE;

    private TimeQueue timeQueue = new TimeQueue();
    private TimeScanThread scanThread;
    private volatile boolean INITED = false;
    private static final Logger LOGGER;

    public synchronized void init() {
        if (!this.INITED) {
            this.scanThread = new TimeScanThread("Schedulerx-TimeScanThread");
            this.scanThread.start();
            LOGGER.info("TimeScanThread started");
            this.INITED = true;
        }
    }

    public void add(TimePlanEntry entry) {
        this.timeQueue.add(entry);
    }

    public void remove(long jobInstanceId) {
        this.timeQueue.remove(jobInstanceId);
    }

    private void submitPlan(TimePlanEntry entry) {
        entry.getHandler().triggerNewCycle();
    }

    static {
        LOGGER = LogFactory.getLogger(TimeScheduler.class);
    }

    class TimeScanThread
    extends Thread {
        public TimeScanThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    TimePlanEntry entry;
                    long now = System.currentTimeMillis();
                    while (!TimeScheduler.this.timeQueue.isEmpty() && (entry = TimeScheduler.this.timeQueue.peek()) != null && entry.getScheduleTimeStamp() <= now) {
                        LOGGER.info("{} time ready", entry);
                        TimeScheduler.this.timeQueue.remove();
                        TimeScheduler.this.submitPlan(entry);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("", e);
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("", e);
                    continue;
                }
                break;
            }
        }
    }
}

