/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.schedulerx.common.domain.HttpAttribute;
import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.enums.HttpRespParseModeEnum;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.org.apache.commons.codec.Charsets;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.shade.org.apache.http.HttpEntity;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.client.config.RequestConfig;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpGet;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPost;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpRequestBase;
import com.alibaba.schedulerx.shade.org.apache.http.conn.ConnectTimeoutException;
import com.alibaba.schedulerx.shade.org.apache.http.entity.ContentType;
import com.alibaba.schedulerx.shade.org.apache.http.entity.StringEntity;
import com.alibaba.schedulerx.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.alibaba.schedulerx.shade.org.apache.http.util.EntityUtils;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.processor.HttpProcessResult;
import com.alibaba.schedulerx.worker.processor.JobProcessorEx;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import com.alibaba.schedulerx.worker.util.HttpClientUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;

public class HttpProcessor
implements JobProcessorEx {
    private LogCollector logCollector = LogCollectorFactory.get();
    protected static final Logger LOGGER = LogFactory.getLogger(HttpProcessor.class);
    private static final int DEFAULT_SOCKET_TIMEOUT = 10;
    private static final int DEFAULT_CONNECT_TIMEOUT = 3;
    private static final int DEFAULT_POOL_CONNECT_TIMEOUT = 5;
    private String uniqueId = null;
    CloseableHttpClient httpClient = HttpClientUtil.getCloseableHttpClient();

    @Override
    public void preProcess(JobContext context) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessResult process(JobContext context) throws Exception {
        this.uniqueId = context.getUniqueId();
        HttpProcessResult processResult = null;
        Closeable httpResponse = null;
        try {
            HttpAttribute httpAttribute = JsonUtil.fromJson(context.getContent(), HttpAttribute.class);
            this.logCollector.collect(context.getAppGroupId(), this.uniqueId, "Http Request URL: " + httpAttribute.getUrl());
            HttpRequestBase request = this.buildHttpRequest(context, httpAttribute);
            this.logCollector.collect(context.getAppGroupId(), this.uniqueId, "Http Request Headers: " + JsonUtil.toJson(request.getAllHeaders()));
            this.logCollector.collect(context.getAppGroupId(), this.uniqueId, "Http Request Parameters: " + this.getHttpRequestParam(context));
            httpResponse = this.httpClient.execute(request);
            processResult = this.parseResponse(context, (HttpResponse)((Object)httpResponse), httpAttribute);
            if (processResult.getStatus() == InstanceStatus.SUCCESS) {
                this.logCollector.collect(context.getAppGroupId(), this.uniqueId, "http callback success");
            } else {
                String msg = "http callback failed: " + processResult.getResult();
                this.logCollector.collect(context.getAppGroupId(), this.uniqueId, msg);
            }
        }
        catch (ConnectTimeoutException | SocketTimeoutException e1) {
            String msg = String.format("http execute timeout, jobId=%s, jobInstanceId=%s", context.getJobId(), context.getJobInstanceId());
            processResult = new HttpProcessResult(InstanceStatus.FAILED, msg);
            LOGGER.error(msg, e1);
            this.logCollector.collect(context.getAppGroupId(), this.uniqueId, msg + ",throwable: " + ExceptionUtil.getTrace(e1));
        }
        catch (Throwable ex) {
            String msg = String.format("http execute error, jobId=%s, jobInstanceId=%s", context.getJobId(), context.getJobInstanceId());
            processResult = new HttpProcessResult(InstanceStatus.FAILED, msg);
            LOGGER.error(msg, ex);
            this.logCollector.collect(context.getAppGroupId(), this.uniqueId, msg + ",throwable: " + ExceptionUtil.getTrace(ex));
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e1) {}
            }
        }
        return processResult;
    }

    @Override
    public ProcessResult postProcess(JobContext context) {
        return null;
    }

    @Override
    public void kill(JobContext context) {
    }

    private String getHttpRequestParam(JobContext context) {
        String params = null;
        if (StringUtils.isNotEmpty(context.getInstanceParameters())) {
            params = context.getInstanceParameters();
        } else if (StringUtils.isNotEmpty(context.getJobParameters())) {
            params = context.getJobParameters();
        }
        return params;
    }

    private HttpRequestBase buildHttpRequest(JobContext context, HttpAttribute httpAttribute) throws IOException {
        HttpRequestBase request = null;
        if (httpAttribute.getTimeout() <= 0) {
            httpAttribute.setTimeout(10);
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(httpAttribute.getTimeout() * 1000).setConnectTimeout(3000).setConnectionRequestTimeout(5000).build();
        if ("GET".equalsIgnoreCase(httpAttribute.getMethod())) {
            request = new HttpGet(httpAttribute.getUrl());
        } else if ("POST".equalsIgnoreCase(httpAttribute.getMethod())) {
            request = new HttpPost(httpAttribute.getUrl());
            String params = null;
            if (StringUtils.isNotEmpty(context.getInstanceParameters())) {
                params = context.getInstanceParameters();
            } else if (StringUtils.isNotEmpty(context.getJobParameters())) {
                params = context.getJobParameters();
            }
            if (StringUtils.isNotBlank(params)) {
                if ("application/x-www-form-urlencoded".equalsIgnoreCase(httpAttribute.getContentType()) || StringUtils.isBlank(httpAttribute.getContentType())) {
                    ContentType contentType = ContentType.create("application/x-www-form-urlencoded", Charsets.UTF_8);
                    StringEntity stringEntity = new StringEntity(params, contentType);
                    ((HttpPost)request).setEntity(stringEntity);
                } else if ("application/json".equalsIgnoreCase(httpAttribute.getContentType())) {
                    ContentType contentType = ContentType.create("application/json", Charsets.UTF_8);
                    StringEntity stringEntity = new StringEntity(params, contentType);
                    ((HttpPost)request).setEntity(stringEntity);
                }
            }
        }
        request.setHeader("Cookie", httpAttribute.getCookie());
        request.setHeader("schedulerx-jobId", String.valueOf(context.getJobId()));
        request.setHeader("schedulerx-groupId", String.valueOf(context.getGroupId()));
        request.setHeader("schedulerx-jobName", URLEncoder.encode(context.getJobName(), Charsets.UTF_8.name()));
        request.addHeader("schedulerx-scheduleTimestamp", String.valueOf(context.getScheduleTime().getMillis()));
        request.addHeader("schedulerx-dataTimestamp", String.valueOf(context.getDataTime().getMillis()));
        request.addHeader("schedulerx-user", URLEncoder.encode(context.getUser(), Charsets.UTF_8.name()));
        request.addHeader("schedulerx-maxAttempt", String.valueOf(context.getMaxAttempt()));
        request.addHeader("schedulerx-attempt", String.valueOf(context.getAttempt()));
        request.addHeader("schedulerx-jobInstanceId", String.valueOf(context.getJobInstanceId()));
        request.setConfig(requestConfig);
        return request;
    }

    private HttpProcessResult parseResponse(JobContext context, HttpResponse httpResponse, HttpAttribute httpAttribute) throws IOException {
        HttpProcessResult result2;
        block25: {
            result2 = null;
            Integer respParseMode = httpAttribute.getRespParseMode();
            if (respParseMode == null) {
                return new HttpProcessResult(InstanceStatus.FAILED, String.format("invalid response parse mode=%s", respParseMode));
            }
            if (httpResponse == null || httpResponse.getStatusLine() == null) {
                return new HttpProcessResult(InstanceStatus.FAILED, "invalid response info");
            }
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            String content = null;
            if (entity != null) {
                content = EntityUtils.toString(entity);
                this.logCollector.collect(context.getAppGroupId(), this.uniqueId, "Http response content: " + content);
            } else {
                this.logCollector.collect(context.getAppGroupId(), this.uniqueId, "Http response content is null");
            }
            if (respParseMode.equals(HttpRespParseModeEnum.CUSTOMIZE_JSON.getValue())) {
                if (responseCode == 200) {
                    if (entity != null) {
                        try {
                            JSONObject jsonObject = JSON.parseObject((String)content);
                            String respVal = jsonObject.getString(httpAttribute.getRespKey());
                            if (!httpAttribute.getRespValue().equals(respVal)) {
                                String msg = String.format("The returned value is different from the expected value: %s", jsonObject.toJSONString());
                                result2 = new HttpProcessResult(InstanceStatus.FAILED, msg);
                                break block25;
                            }
                            result2 = new HttpProcessResult(InstanceStatus.SUCCESS, jsonObject.toJSONString());
                        }
                        catch (JSONException e) {
                            String msg = String.format("Json parse failed, jobId=%s, jobInstanceId=%s", context.getJobId(), context.getJobInstanceId());
                            LOGGER.error(msg, e);
                            result2 = new HttpProcessResult(InstanceStatus.FAILED, msg);
                        }
                    } else {
                        result2 = new HttpProcessResult(InstanceStatus.FAILED, "httpResponse entity is null");
                    }
                } else {
                    String msg = String.format("http response code is not 200, response code=%s, uri=%s, jobId=%s, jobInstanceId=%s", responseCode, httpAttribute.getUrl(), context.getJobId(), context.getJobInstanceId());
                    LOGGER.error(msg);
                    result2 = new HttpProcessResult(InstanceStatus.FAILED, msg);
                }
            } else if (respParseMode.equals(HttpRespParseModeEnum.RESPONSE_CODE.getValue())) {
                if (!httpAttribute.getRespCode().equals(responseCode)) {
                    String msg = String.format("http responseCode is different from the expected value,expected value=%s, actual value=%s", httpAttribute.getRespCode(), responseCode);
                    result2 = new HttpProcessResult(InstanceStatus.FAILED, msg);
                } else {
                    result2 = new HttpProcessResult(InstanceStatus.SUCCESS, content);
                }
            } else if (respParseMode.equals(HttpRespParseModeEnum.CUSTOMIZE_STRING.getValue())) {
                if (responseCode == 200) {
                    if (entity != null) {
                        if (!StringUtils.equals(content, httpAttribute.getRespStr())) {
                            String msg = String.format("http returned value different from the expected value, expected value=%s, actual value=%s", httpAttribute.getRespStr(), content);
                            result2 = new HttpProcessResult(InstanceStatus.FAILED, msg);
                        } else {
                            result2 = new HttpProcessResult(InstanceStatus.SUCCESS, content);
                        }
                    } else {
                        String msg = String.format("http returned value different from the expected value, expected value=%s, actual value=%s", httpAttribute.getRespStr(), content);
                        result2 = new HttpProcessResult(InstanceStatus.FAILED, msg);
                    }
                } else {
                    String msg = String.format("http response code is not 200,response code=%s, uri=%s, jobId=%s, jobInstanceId=%s", responseCode, httpAttribute.getUrl(), context.getJobId(), context.getJobInstanceId());
                    LOGGER.error(msg);
                    result2 = new HttpProcessResult(InstanceStatus.FAILED, msg);
                }
            } else {
                result2 = new HttpProcessResult(InstanceStatus.FAILED, String.format("invalid response parse mode=%s", respParseMode));
            }
        }
        return result2;
    }
}

