/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor;

import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;

public class ProcessResult {
    protected InstanceStatus status;
    protected String result;
    protected String stackInfo;

    public ProcessResult() {
    }

    public ProcessResult(InstanceStatus status) {
        this.status = status;
        if (InstanceStatus.FAILED.equals(status)) {
            this.stackInfo = this.stackInfo();
        }
    }

    public ProcessResult(boolean status) {
        InstanceStatus instanceStatus = this.status = status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED;
        if (!status) {
            this.stackInfo = this.stackInfo();
        }
    }

    public ProcessResult(InstanceStatus status, String result2) {
        this.result = result2 != null && result2.getBytes().length > 1000 ? StringUtils.substring(result2, 0, 990) + "..." : result2;
        this.status = status;
        if (InstanceStatus.FAILED.equals(status)) {
            this.stackInfo = this.stackInfo();
        }
    }

    private String stackInfo() {
        return "";
    }

    public ProcessResult(boolean status, String result2) {
        this.result = result2 != null && result2.getBytes().length > 1000 ? StringUtils.substring(result2, 0, 990) + "..." : result2;
        InstanceStatus instanceStatus = this.status = status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED;
        if (InstanceStatus.FAILED.equals(this.status)) {
            this.stackInfo = this.stackInfo();
        }
    }

    public InstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(InstanceStatus status) {
        this.status = status;
        this.stackInfo = InstanceStatus.FAILED.equals(status) ? this.stackInfo() : null;
    }

    public void setStatus(boolean status) {
        this.setStatus(status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
    }

    public String getResult() {
        if (StringUtils.isEmpty(this.result) && StringUtils.isNotEmpty(this.stackInfo)) {
            return StringUtils.substring(this.stackInfo, 0, 1000);
        }
        return this.result;
    }

    public void setResult(String result2) {
        this.result = result2 != null && result2.getBytes().length > 1000 ? StringUtils.substring(result2, 0, 990) + "..." : result2;
    }

    public String toString() {
        return "ProcessResult [status=" + this.status + ", result=" + this.result + "]";
    }
}

