/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor;

import com.alibaba.schedulerx.common.domain.ScriptJobXAttrs;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.io.Files;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.processor.ShellProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class PythonProcessor
extends ShellProcessor {
    public static final String PYTHON_SCRIPT_PREFIX = System.getProperties().getProperty("user.home") + "/script/python/";
    protected String fileName;

    @Override
    public void preProcess(JobContext context) throws Exception {
        super.preProcess(context);
        File dir = new File(PYTHON_SCRIPT_PREFIX);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.fileName = this.writePythonScript(context);
    }

    @Override
    protected String[] getContent(JobContext context) {
        String[] parameters = StringUtils.isNotEmpty(context.getShardingParameter()) ? new String[]{String.valueOf(context.getShardingId()), context.getShardingParameter()} : (StringUtils.isNotEmpty(context.getInstanceParameters()) ? context.getInstanceParameters().trim().split(" ") : context.getJobParameters().trim().split(" "));
        ArrayList<String> contentList = Lists.newArrayList();
        ScriptJobXAttrs xAttrs = null;
        if (StringUtils.isNotEmpty(context.getXAttrs())) {
            xAttrs = JsonUtil.fromJson(context.getXAttrs(), ScriptJobXAttrs.class);
        }
        if (xAttrs != null && StringUtils.isNotEmpty(xAttrs.getArch())) {
            contentList.add("arch");
            contentList.add("-" + xAttrs.getArch());
        }
        if (xAttrs != null && StringUtils.isNotEmpty(xAttrs.getCommand())) {
            contentList.add(xAttrs.getCommand());
        } else {
            contentList.add("python");
        }
        contentList.add(this.fileName);
        for (int i = 0; i < parameters.length; ++i) {
            contentList.add(parameters[i]);
        }
        return contentList.toArray(new String[contentList.size()]);
    }

    private String writePythonScript(JobContext context) throws IOException {
        long jobId = context.getJobId();
        String fileName = PYTHON_SCRIPT_PREFIX + "python_" + jobId + ".py";
        String content = this.parseContent(context);
        content = "# -*- coding: utf-8 -*-" + System.lineSeparator() + content;
        Files.write(content.getBytes(), new File(fileName));
        return fileName;
    }
}

