/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor.springscheduling;

import com.alibaba.schedulerx.scheduling.annotation.SchedulerX;
import com.alibaba.schedulerx.worker.processor.springscheduling.SchedulerxSchedulingConfigurer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.Schedules;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class SchedulerxAnnotationBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    @Nullable
    private BeanFactory beanFactory;
    @Autowired
    private SchedulerxSchedulingConfigurer schedulerxSchedulingConfigurer;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Set methods;
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(targetClass) && (methods = MethodIntrospector.selectMethods((Class)targetClass, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                Set scheduledMethods = AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)method, SchedulerX.class);
                return !CollectionUtils.isEmpty((Collection)scheduledMethods);
            }
        })) != null && methods.size() > 0) {
            for (Method method : methods) {
                Set scheduledMethods = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, Scheduled.class, Schedules.class);
                if (scheduledMethods != null && scheduledMethods.size() > 0) continue;
                this.schedulerxSchedulingConfigurer.register(bean, method, true);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

