/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor.springscheduling;

import com.alibaba.schedulerx.common.domain.Pair;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.worker.processor.springscheduling.NoOpScheduler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.config.Task;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.ClassUtils;

@Order
public class SchedulerxSchedulingConfigurer
implements SchedulingConfigurer,
InitializingBean {
    private final Map<String, Pair<Object, Method>> scheduledTaskTargetMap = Maps.newConcurrentMap();
    private final Map<String, Pair<Object, Method>> schedulerXTaskTargetMap = Maps.newConcurrentMap();
    private static SchedulerxSchedulingConfigurer instance = null;
    @Autowired
    private NoOpScheduler scheduler;

    public static SchedulerxSchedulingConfigurer getInstance() {
        return instance;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        ArrayList<Task> scheduledTasks = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(taskRegistrar.getCronTaskList())) {
            scheduledTasks.addAll(taskRegistrar.getCronTaskList());
        }
        if (CollectionUtils.isNotEmpty(taskRegistrar.getFixedDelayTaskList())) {
            scheduledTasks.addAll(taskRegistrar.getFixedDelayTaskList());
        }
        if (CollectionUtils.isNotEmpty(taskRegistrar.getFixedRateTaskList())) {
            scheduledTasks.addAll(taskRegistrar.getFixedRateTaskList());
        }
        if (CollectionUtils.isNotEmpty(taskRegistrar.getTriggerTaskList())) {
            scheduledTasks.addAll(taskRegistrar.getTriggerTaskList());
        }
        for (Task task : scheduledTasks) {
            if (!(task.getRunnable() instanceof ScheduledMethodRunnable)) continue;
            ScheduledMethodRunnable runnable = (ScheduledMethodRunnable)task.getRunnable();
            this.register(runnable.getTarget(), runnable.getMethod(), false);
        }
        taskRegistrar.setScheduler((Object)this.scheduler);
    }

    public void register(Object target, Method method, boolean isSchedulerX) {
        String className = AopProxyUtils.ultimateTargetClass((Object)target).getName();
        if (ClassUtils.isCglibProxyClassName((String)className)) {
            className = ClassUtils.getUserClass((Object)target).getName();
        }
        String methodName = method.getName();
        if (isSchedulerX) {
            this.schedulerXTaskTargetMap.put(className + ":" + methodName, new Pair<Object, Method>(target, method));
        } else {
            this.scheduledTaskTargetMap.put(className + ":" + methodName, new Pair<Object, Method>(target, method));
        }
    }

    public Pair<Object, Method> getScheduledTaskTarget(String key) {
        if (this.schedulerXTaskTargetMap.get(key) != null) {
            return this.schedulerXTaskTargetMap.get(key);
        }
        return this.scheduledTaskTargetMap.get(key);
    }

    public Collection<Pair<Object, Method>> getSchedulerXTaskTargets() {
        return this.schedulerXTaskTargetMap.values();
    }

    public void afterPropertiesSet() throws Exception {
        instance = this;
    }
}

