/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.route;

import com.alibaba.schedulerx.common.domain.RouteTargetNode;
import com.alibaba.schedulerx.common.domain.strategy.PercentStrategy;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.common.util.RouteUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.google.gson.reflect.TypeToken;
import com.alibaba.schedulerx.worker.route.Router;
import java.util.List;
import java.util.Map;

public class PercentRouter
extends Router {
    private static final Map<String, Map<String, RouteTargetNode>> WORKER_ROUTE_TARGET_CAL_MAP = Maps.newConcurrentMap();
    private List<PercentStrategy> strategyList = Lists.newArrayList();

    @Override
    public void init(String strategyContent) {
        List strategyListFromContent = (List)JsonUtil.fromJson(strategyContent, new TypeToken<List<PercentStrategy>>(){}.getType());
        if (strategyListFromContent != null) {
            this.strategyList = strategyListFromContent;
        }
        this.initStrategyList();
    }

    @Override
    public String route(long appGroupId, long jobId, List<String> allWorkerList, Map<String, List<String>> targetWorkerAddrsMap, long loopCount, String masterWorkerIdAddr) {
        return this.getWorkerAddr(appGroupId, jobId, targetWorkerAddrsMap);
    }

    public String getWorkerAddr(long appGroupId, long jobId, Map<String, List<String>> targetWorkerAddrsMap) {
        if (targetWorkerAddrsMap.isEmpty()) {
            return null;
        }
        LOGGER.info("targetWorkerAddrsMap={}", targetWorkerAddrsMap);
        String key = IdUtil.getRouteStrategyUniqueId(appGroupId, jobId);
        Map<String, RouteTargetNode> map2 = WORKER_ROUTE_TARGET_CAL_MAP.get(key);
        if (map2 == null) {
            WORKER_ROUTE_TARGET_CAL_MAP.put(key, Maps.newConcurrentMap());
            map2 = WORKER_ROUTE_TARGET_CAL_MAP.get(key);
        }
        String target = RouteUtil.selectTarget(this.strategyList, map2);
        LOGGER.info("target={}", (Object)target);
        List<String> workerAddrList = targetWorkerAddrsMap.get(target);
        if (workerAddrList == null || workerAddrList.isEmpty()) {
            return null;
        }
        int randomIndex = (int)(Math.random() * (double)workerAddrList.size());
        return workerAddrList.get(randomIndex);
    }

    private void initStrategyList() {
        PercentStrategy leftPart = new PercentStrategy();
        if (this.strategyList.size() > 0) {
            leftPart.setTargetType(this.strategyList.get(0).getTargetType());
            leftPart.setTarget("[]");
            int leftPercentage = 100;
            for (PercentStrategy strategy : this.strategyList) {
                leftPercentage -= strategy.getPercentage();
            }
            if (leftPercentage >= 0) {
                leftPart.setPercentage(leftPercentage);
                this.strategyList.add(leftPart);
            }
        }
    }
}

