/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.route;

import com.alibaba.schedulerx.common.util.StringUtils;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.worker.metrics.WorkerLoad;
import com.alibaba.schedulerx.worker.metrics.WorkerLoadRegister;
import com.alibaba.schedulerx.worker.route.Router;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class WorkerLoadRouter
extends Router
implements WorkerLoadRegister {
    private int index = 0;
    private static final Random r = new Random();
    private Map<String, WorkerLoad> workerLoadMap = Maps.newHashMap();

    @Override
    public void init(String strategyContent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String route(long appGroupId, long jobId, List<String> workerList, Map<String, List<String>> targetWorkerAddsMap, long loopCount, String masterWorkerIdAddr) {
        int size2 = workerList.size();
        if (size2 == 0) {
            return null;
        }
        ArrayList<String> availableWorkers = Lists.newArrayList();
        WorkerLoadRouter workerLoadRouter = this;
        synchronized (workerLoadRouter) {
            while (true) {
                if (CollectionUtils.isEmpty(availableWorkers)) {
                    size2 = workerList.size();
                } else {
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 12] lbl11 : MonitorExitStatement: MONITOREXIT : var12_9
                    String selected = null;
                    if (availableWorkers.size() <= 1) {
                        return (String)availableWorkers.get(0);
                    }
                    int a = r.nextInt(availableWorkers.size());
                    int b = r.nextInt(availableWorkers.size() - 1);
                    if (b == a) {
                        ++b;
                    }
                    String workerA = (String)availableWorkers.get(a);
                    String workerB = (String)availableWorkers.get(b);
                    if (StringUtils.equals(workerA, masterWorkerIdAddr)) {
                        return workerB;
                    }
                    if (StringUtils.equals(workerB, masterWorkerIdAddr)) {
                        return workerA;
                    }
                    if (!(this.workerLoadMap.get(workerA).getWeight() > this.workerLoadMap.get(workerB).getWeight())) return workerB;
                    return workerA;
                }
                for (int i = 0; i < size2; ++i, ++this.index) {
                    WorkerLoad workerLoad;
                    if (this.index < 0) {
                        this.index = 0;
                    }
                    if ((workerLoad = this.workerLoadMap.get(workerList.get(this.index % size2))) == null) {
                        this.getWorkLoad(workerList.get(this.index % size2));
                        return workerList.get(this.index % size2);
                    }
                    if (!workerLoad.isAvailable()) continue;
                    availableWorkers.add(workerList.get(this.index % size2));
                }
                try {
                    if (!CollectionUtils.isEmpty(availableWorkers)) continue;
                    LOGGER.info("wait available worker. worker size:{}", (Object)workerList.size());
                    this.wait(15000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void set(String workerAddr, WorkerLoad workerLoad) {
        this.workerLoadMap.put(workerAddr, workerLoad);
    }

    @Override
    public void setAvailableSize(String workerAddr, Integer availableSize) {
        WorkerLoad workerLoad = this.getWorkLoad(workerAddr);
        workerLoad.setAvailableSize(availableSize);
    }

    @Override
    public void setRemainCpu(String workerAddr, Integer remainCpu) {
        WorkerLoad workerLoad = this.getWorkLoad(workerAddr);
        workerLoad.setRemainCpu(remainCpu);
    }

    @Override
    public void setRemainMemory(String workerAddr, Long remainMemory) {
        WorkerLoad workerLoad = this.getWorkLoad(workerAddr);
        workerLoad.setRemainMemory(remainMemory);
    }

    @Override
    public void setCost(String workerAddr, Long cost) {
        WorkerLoad workerLoad = this.getWorkLoad(workerAddr);
        workerLoad.setCost(cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerLoad getWorkLoad(String workerAddr) {
        WorkerLoad workerLoad = this.workerLoadMap.get(workerAddr);
        if (workerLoad == null) {
            Map<String, WorkerLoad> map2 = this.workerLoadMap;
            synchronized (map2) {
                workerLoad = this.workerLoadMap.get(workerAddr);
                if (workerLoad == null) {
                    workerLoad = new WorkerLoad(workerAddr);
                    this.workerLoadMap.put(workerAddr, workerLoad);
                }
            }
        }
        return workerLoad;
    }

    @Override
    public void clear() {
        this.workerLoadMap.clear();
    }

    public static void main(String[] args) {
        Integer a;
        Integer n = a = Integer.valueOf(10);
        Integer n2 = a = Integer.valueOf(a - 1);
        System.out.println(a);
    }
}

