/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.service;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.org.apache.http.ExceptionLogger;
import com.alibaba.schedulerx.shade.org.apache.http.HttpException;
import com.alibaba.schedulerx.shade.org.apache.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.MethodNotSupportedException;
import com.alibaba.schedulerx.shade.org.apache.http.NameValuePair;
import com.alibaba.schedulerx.shade.org.apache.http.client.utils.URIBuilder;
import com.alibaba.schedulerx.shade.org.apache.http.entity.ContentType;
import com.alibaba.schedulerx.shade.org.apache.http.impl.nio.bootstrap.HttpServer;
import com.alibaba.schedulerx.shade.org.apache.http.impl.nio.bootstrap.ServerBootstrap;
import com.alibaba.schedulerx.shade.org.apache.http.impl.nio.reactor.IOReactorConfig;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.NStringEntity;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncExchange;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpContext;
import com.alibaba.schedulerx.worker.service.WorkerControlService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class WorkerHttpServer {
    private WorkerControlService workerControlService = new WorkerControlService();

    public WorkerHttpServer() throws IOException {
        int port = ConfigUtil.getWorkerConfig().getInt("worker.http.server.port", 51886);
        IOReactorConfig config = IOReactorConfig.custom().setSoTimeout(15000).setIoThreadCount(1).setTcpNoDelay(true).build();
        HttpServer server = ServerBootstrap.bootstrap().setListenerPort(port).setServerInfo("SchedulerX-Http-Server/1.1").setIOReactorConfig(config).setSslContext(null).setExceptionLogger(ExceptionLogger.STD_ERR).registerHandler("/schedulerx/worker/*", new WorkerHttpRequestHandler()).create();
        server.start();
    }

    class WorkerHttpRequestHandler
    implements HttpAsyncRequestHandler<HttpRequest> {
        WorkerHttpRequestHandler() {
        }

        @Override
        public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            return new BasicAsyncRequestConsumer();
        }

        @Override
        public void handle(HttpRequest request, HttpAsyncExchange httpExchange, HttpContext context) throws HttpException {
            HttpResponse response = httpExchange.getResponse();
            this.handleInternal(request, response, context);
            httpExchange.submitResponse(new BasicAsyncResponseProducer(response));
        }

        private void handleInternal(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
            JSONResult jsonResult;
            String action;
            String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
            if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
                throw new MethodNotSupportedException(method + " method not supported");
            }
            String uri = request.getRequestLine().getUri();
            int endIndex = uri.contains("?") ? uri.indexOf("?") : uri.length();
            switch (action = uri.substring(uri.lastIndexOf("/") + 1, endIndex)) {
                case "shutdown": {
                    Integer modeObject = null;
                    try {
                        URIBuilder builder = new URIBuilder(uri);
                        List<NameValuePair> params = builder.getQueryParams();
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        for (NameValuePair param2 : params) {
                            paramMap.put(param2.getName(), param2.getValue());
                        }
                        modeObject = paramMap.get("mode") != null ? Integer.valueOf(Integer.parseInt((String)paramMap.get("mode"))) : null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jsonResult = WorkerHttpServer.this.workerControlService.shutdown(modeObject);
                    break;
                }
                case "restart": {
                    jsonResult = WorkerHttpServer.this.workerControlService.restart();
                    break;
                }
                case "config": {
                    jsonResult = WorkerHttpServer.this.workerControlService.config();
                    break;
                }
                default: {
                    jsonResult = JSONResult.geneFailResult("not support action.");
                }
            }
            response.setStatusCode(jsonResult.isSuccess() ? 200 : 501);
            NStringEntity body2 = new NStringEntity(JsonUtil.toJson(jsonResult), ContentType.APPLICATION_JSON);
            response.setEntity(body2);
        }
    }
}

