/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.timer.AbstractTimerTask;
import com.alibaba.schedulerx.worker.util.ConsoleUtil;
import java.util.List;
import java.util.Random;

public class DomainNameUpdateTimer
extends AbstractTimerTask {
    @Override
    public String getName() {
        return "DomainNameUpdateTimer";
    }

    @Override
    public long getInitialDelay() {
        return 300L;
    }

    @Override
    public long getPeriod() {
        return 60L;
    }

    @Override
    public void run() {
        if (StringUtils.isNotBlank(System.getProperty("schedulerx.console.domain"))) {
            return;
        }
        String addressServer = (String)ConfigUtil.getWorkerConfig().getProperty("address.server.domain");
        if (StringUtils.isBlank(addressServer)) {
            return;
        }
        String port = (String)ConfigUtil.getWorkerConfig().getProperty("address.server.port");
        List<String> vipList = ConsoleUtil.getVipServerList(addressServer, port);
        if (CollectionUtils.isEmpty(vipList)) {
            return;
        }
        String domainName = ConfigUtil.getWorkerConfig().getString("domainName");
        if (vipList.contains(domainName)) {
            return;
        }
        int index = 0;
        if (vipList.size() > 1) {
            Random random = new Random();
            index = random.nextInt(vipList.size());
        }
        String temp = vipList.get(index);
        LOGGER.info("DomainName update. Change domain name [{}] to [{}].", domainName, temp);
        ConfigUtil.getWorkerConfig().setProperty("domainName", temp);
    }
}

