/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import com.alibaba.schedulerx.worker.master.persistence.H2FilePersistence;
import com.alibaba.schedulerx.worker.master.persistence.H2MemoryPersistence;
import com.alibaba.schedulerx.worker.master.persistence.H2Persistence;
import com.alibaba.schedulerx.worker.timer.AbstractTimerTask;
import java.util.List;

public class JobInstanceCleanTimer
extends AbstractTimerTask {
    private TaskMasterPool masterPool = TaskMasterPool.INSTANCE;

    @Override
    public String getName() {
        return "JobInstanceCleanTimer";
    }

    @Override
    public long getInitialDelay() {
        return 60L;
    }

    @Override
    public long getPeriod() {
        return 120L;
    }

    @Override
    public void run() {
        try {
            if (H2MemoryPersistence.getInstance().isInited()) {
                this.handleToCleanInstances(H2MemoryPersistence.getInstance());
            }
            if (H2FilePersistence.getInstance().isInited()) {
                this.handleToCleanInstances(H2MemoryPersistence.getInstance());
            }
        }
        catch (Throwable e) {
            LOGGER.warn("JobInstanceCleanTimer run error", e);
        }
    }

    private void handleToCleanInstances(H2Persistence h2Persistence) throws Exception {
        List<Long> instanceIds = h2Persistence.getDistinctInstanceIds();
        if (CollectionUtils.isNotEmpty(instanceIds)) {
            for (Long instanceId : instanceIds) {
                if (this.masterPool.contains(instanceId)) continue;
                h2Persistence.clearTasks(instanceId);
                LOGGER.info("clear tasks instanceId: {}", instanceId);
            }
        }
    }
}

