/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.RouteStrategyInfoForSync;
import com.alibaba.schedulerx.common.domain.TriggerType;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.common.util.UnirestUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.google.common.collect.Sets;
import com.alibaba.schedulerx.shade.com.google.gson.reflect.TypeToken;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.ListUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.MapUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.discovery.GroupManager;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import com.alibaba.schedulerx.worker.route.Router;
import com.alibaba.schedulerx.worker.route.RouterFactory;
import com.alibaba.schedulerx.worker.route.RouterManager;
import com.alibaba.schedulerx.worker.timer.AbstractTimerTask;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskMasterUpdateWorkersTimer
extends AbstractTimerTask {
    private TaskMasterPool masterPool = TaskMasterPool.INSTANCE;
    private RouterManager routerManager = RouterManager.INSTANCE;
    protected static final Logger LOGGER = LogFactory.getLogger(TaskMasterUpdateWorkersTimer.class);
    private static int errorCount = 0;

    @Override
    public String getName() {
        return "TaskMasterUpdateWorkersTimer";
    }

    @Override
    public long getInitialDelay() {
        return 60L;
    }

    @Override
    public long getPeriod() {
        return 60L;
    }

    @Override
    public void run() {
        try {
            String groupId;
            Collection<TaskMaster> allTaskMaster = this.masterPool.getAllTaskMaster();
            if (CollectionUtils.isEmpty(allTaskMaster)) {
                return;
            }
            HashMap jobInstanceMap = Maps.newHashMap();
            HashMap appGroupJob = Maps.newHashMap();
            HashMap<Long, String> appGroupIdMap = Maps.newHashMap();
            for (TaskMaster taskMaster : allTaskMaster) {
                Long jobId = taskMaster.getJobInstanceInfo().getJobId();
                if (TriggerType.MANUAL.getValue() == taskMaster.getJobInstanceInfo().getTriggerType()) continue;
                ArrayList<JobInstanceInfo> list = (ArrayList<JobInstanceInfo>)jobInstanceMap.get(jobId);
                if (list == null) {
                    list = Lists.newArrayList();
                    jobInstanceMap.put(jobId, list);
                }
                list.add(taskMaster.getJobInstanceInfo());
                Long appGroupId = taskMaster.getJobInstanceInfo().getAppGroupId();
                groupId = taskMaster.getJobInstanceInfo().getGroupId();
                appGroupIdMap.put(appGroupId, groupId);
                ArrayList<Long> agList = (ArrayList<Long>)appGroupJob.get(appGroupId);
                if (agList == null) {
                    agList = Lists.newArrayList();
                    appGroupJob.put(appGroupId, agList);
                }
                agList.add(jobId);
            }
            HashMap hasNotDesignatedAppGroupJob = Maps.newHashMap();
            ArrayList<Long> hasDesignatedJobIds = Lists.newArrayList();
            ArrayList hasRouteStrategyJobIds = Lists.newArrayList();
            for (Map.Entry entry : appGroupJob.entrySet()) {
                groupId = (String)appGroupIdMap.get(entry.getKey());
                JSONResult result2 = this.grepHasDesignateJobIds((Long)entry.getKey(), (List)entry.getValue(), GroupManager.INSTANCE.getAppKeyByGroupId(groupId));
                Set idsWithDesignate = Sets.newHashSet();
                if (result2 != null && result2.getData() != null) {
                    if (result2.getCode() == 400) {
                        Map idsMap = (Map)JsonUtil.fromJson(JsonUtil.toJson(result2.getData()), new TypeToken<Map<String, Set<Long>>>(){}.getType());
                        idsWithDesignate = (Set)idsMap.get("designate");
                        Set idsWithRouteStrategy = (Set)idsMap.get("routeStrategy");
                        if (CollectionUtils.isNotEmpty(idsWithRouteStrategy)) {
                            HashSet<Long> idSet = new HashSet<Long>(idsWithRouteStrategy.size());
                            Iterator iterator2 = idsWithRouteStrategy.iterator();
                            while (iterator2.hasNext()) {
                                Number n = (Number)iterator2.next();
                                idSet.add(n.longValue());
                            }
                            hasRouteStrategyJobIds.addAll(idSet);
                        }
                    } else if (result2.getData() instanceof Collection) {
                        idsWithDesignate = new HashSet((Collection)result2.getData());
                    }
                }
                if (CollectionUtils.isNotEmpty(idsWithDesignate)) {
                    HashSet<Long> idSet = new HashSet<Long>(idsWithDesignate.size());
                    for (Number n : idsWithDesignate) {
                        idSet.add(n.longValue());
                    }
                    hasDesignatedJobIds.addAll(idSet);
                    hasNotDesignatedAppGroupJob.put(entry.getKey(), ListUtils.removeAll((Collection)entry.getValue(), idSet));
                    continue;
                }
                hasNotDesignatedAppGroupJob.put(entry.getKey(), (List<Object>)entry.getValue());
            }
            if (MapUtils.isNotEmpty(hasNotDesignatedAppGroupJob)) {
                for (Map.Entry entry : hasNotDesignatedAppGroupJob.entrySet()) {
                    groupId = (String)appGroupIdMap.get(entry.getKey());
                    Set<String> allWorkers = this.getAllWorkers((Long)entry.getKey(), -1L, GroupManager.INSTANCE.getAppKeyByGroupId(groupId));
                    for (Long jobId : (List)entry.getValue()) {
                        if (hasRouteStrategyJobIds.contains(jobId)) {
                            RouteStrategyInfoForSync strategyInfoForSync = this.getRouteStrategyInfoForSync((Long)entry.getKey(), jobId, GroupManager.INSTANCE.getAppKeyByGroupId(groupId));
                            this.updateWorkers(allWorkers, (List)jobInstanceMap.get(jobId), strategyInfoForSync);
                            continue;
                        }
                        this.updateWorkers(allWorkers, (List)jobInstanceMap.get(jobId));
                    }
                }
            }
            for (Long jobId : hasDesignatedJobIds) {
                Long appGroupId = ((JobInstanceInfo)((List)jobInstanceMap.get(jobId)).get(0)).getAppGroupId();
                String groupId2 = (String)appGroupIdMap.get(appGroupId);
                Set<String> allWorkers = this.getAllWorkers(appGroupId, jobId, GroupManager.INSTANCE.getAppKeyByGroupId(groupId2));
                this.updateWorkers(allWorkers, (List)jobInstanceMap.get(jobId));
            }
            errorCount = 0;
        }
        catch (Exception ex) {
            if (errorCount++ < 10) {
                LOGGER.warn("can not update master workers. {}", ex.getMessage());
            }
            LOGGER.error("update master workers error.", ex);
        }
    }

    private JSONResult grepHasDesignateJobIds(Long appGroupId, List<Long> jobIds, String appKey) throws Exception {
        String url = "http://{0}/app/grepHasDesignateJobIds.json?appGroupId={1}&jobIds={2}&appKey={3}&grepRouteStrategyJobIds=true";
        return UnirestUtil.getResult(url, null, ConfigUtil.getWorkerConfig().getString("domainName"), appGroupId, StringUtils.join(jobIds, ","), URLEncoder.encode(appKey == null ? "" : appKey, "UTF-8"));
    }

    private void updateWorkers(Set<String> allWorkers, List<JobInstanceInfo> instanceInfos) {
        this.updateWorkers(allWorkers, instanceInfos, null);
    }

    private void updateWorkers(Set<String> allWorkers, List<JobInstanceInfo> instanceInfos, RouteStrategyInfoForSync strategyInfoForSync) {
        if (CollectionUtils.isEmpty(allWorkers)) {
            return;
        }
        for (JobInstanceInfo instanceInfo : instanceInfos) {
            if (instanceInfo.getAllWorkers().size() != allWorkers.size() || !instanceInfo.getAllWorkers().containsAll(allWorkers)) {
                instanceInfo.setAllWorkers(Lists.newCopyOnWriteArrayList(allWorkers));
                LOGGER.info("update appGroupId={} instanceId={} workers.", instanceInfo.getAppGroupId(), instanceInfo.getJobInstanceId());
            }
            if (this.isRouteStrategyInfoNeedSync(instanceInfo, strategyInfoForSync)) {
                instanceInfo.setRouteStrategyType(strategyInfoForSync.getType());
                instanceInfo.setRouteStrategyContent(strategyInfoForSync.getStrategyContent());
                Router router = RouterFactory.buildRouter(strategyInfoForSync.getType(), strategyInfoForSync.getStrategyContent());
                this.routerManager.updateRouter(instanceInfo.getAppGroupId(), instanceInfo.getJobId(), router);
            }
            if (strategyInfoForSync == null || strategyInfoForSync.getTargetWorkerAddrsMap() == null) continue;
            instanceInfo.setTargetWorkerAddrsMap(strategyInfoForSync.getTargetWorkerAddrsMap());
        }
    }

    private Set<String> getAllWorkers(Long appGroupId, Long jobId, String appKey) throws Exception {
        String url = "http://{0}/app/getAllUsefulWorkerList.json?appGroupId={1}&jobId={2}&appKey={3}";
        try {
            return UnirestUtil.getSetData(url, ConfigUtil.getWorkerConfig().getString("domainName"), appGroupId, jobId, URLEncoder.encode(appKey == null ? "" : appKey, "UTF-8"));
        }
        catch (Exception ex) {
            if (errorCount++ < 10) {
                LOGGER.warn("getAllWorkers failed. {}", ex.getMessage());
            } else {
                LOGGER.error("getAllWorkers failed.", ex);
            }
            return null;
        }
    }

    private Map<String, List<String>> getTargetWorkerAddrsMap(Long appGroupId, Long jobId, String appKey) throws Exception {
        String url = "http://{0}/worker/v1/appgroup/getTaregtWorkerAddrsMap.json?appGroupId={1}&jobId={2}&appKey={3}";
        return UnirestUtil.getMapData(url, ConfigUtil.getWorkerConfig().getString("domainName"), appGroupId, jobId, URLEncoder.encode(appKey == null ? "" : appKey, "UTF-8"));
    }

    private RouteStrategyInfoForSync getRouteStrategyInfoForSync(Long appGroupId, Long jobId, String appKey) throws Exception {
        String url = "http://{0}/worker/v1/appgroup/getRouteStrategyInfoForSync.json?appGroupId={1}&jobId={2}&appKey={3}";
        JSONResult result2 = UnirestUtil.getResult(url, null, ConfigUtil.getWorkerConfig().getString("domainName"), appGroupId, jobId, URLEncoder.encode(appKey == null ? "" : appKey, "UTF-8"));
        if (result2.isSuccess()) {
            String jsonStr = JsonUtil.toJson(result2.getData());
            RouteStrategyInfoForSync routeStrategyInfoForSync = JsonUtil.fromJson(jsonStr, RouteStrategyInfoForSync.class);
            return routeStrategyInfoForSync;
        }
        return null;
    }

    private boolean isRouteStrategyInfoNeedSync(JobInstanceInfo instanceInfo, RouteStrategyInfoForSync routeStrategyInfoForSync) {
        if (routeStrategyInfoForSync == null) {
            return false;
        }
        return !instanceInfo.getRouteStrategyType().equals(routeStrategyInfoForSync.getType()) || !instanceInfo.getRouteStrategyContent().equals(routeStrategyInfoForSync.getStrategyContent());
    }
}

