/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.common.validations;

import com.allianz.cn.pc.common.annotation.XmlConfig;
import com.allianz.cn.pc.common.exceptions.XmlValidationException;
import com.allianz.cn.pc.common.validations.ValidationConst;
import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.ResourceUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class XmlValidation {
    public static void validateField(Object object) throws XmlValidationException {
        Field[] fd;
        for (Field f : fd = object.getClass().getDeclaredFields()) {
            XmlConfig an = f.getAnnotation(XmlConfig.class);
            XStreamAlias alias = f.getAnnotation(XStreamAlias.class);
            if (Beans.isEmpty(an)) continue;
            String fildName = alias.value();
            f.setAccessible(true);
            boolean requireFlag = an.require();
            Class clazz = an.type();
            String datePattern = an.datePattern();
            int len = an.length();
            String[] enumValue = an.enumValue();
            Object obj = null;
            try {
                obj = f.get(object);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            if (requireFlag && Beans.isEmpty(obj)) {
                throw new XmlValidationException(ValidationConst.ErrorCode.notNull.value, ResourceUtil.errorCodeMsg(null, ValidationConst.ErrorCode.notNull.value, fildName));
            }
            if (!Beans.isNotEmpty(obj)) continue;
            if (Object.class == clazz) {
                XmlValidation.validateField(obj);
                continue;
            }
            if (Date.class == clazz) {
                if (XmlValidation.validateDate(obj.toString(), datePattern)) continue;
                throw new XmlValidationException(ValidationConst.ErrorCode.wrongDateFormat.value, ResourceUtil.errorCodeMsg(null, ValidationConst.ErrorCode.wrongDateFormat.value, fildName, datePattern));
            }
            if (Collection.class == clazz) {
                Collection newObj = (Collection)obj;
                Iterator iter = newObj.iterator();
                while (iter.hasNext()) {
                    XmlValidation.validateField(iter.next());
                }
                continue;
            }
            if (Integer.class == clazz) {
                try {
                    Integer.valueOf(obj.toString());
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new XmlValidationException(ValidationConst.ErrorCode.numberFormat.value, ResourceUtil.errorCodeMsg(null, ValidationConst.ErrorCode.numberFormat.value, fildName));
                }
            }
            if (String.class == clazz) {
                String sObj = obj.toString();
                if (sObj.length() <= len) continue;
                throw new XmlValidationException(ValidationConst.ErrorCode.overlength.value, ResourceUtil.errorCodeMsg(null, ValidationConst.ErrorCode.overlength.value, fildName, String.valueOf(len)));
            }
            if (Enum.class == clazz) {
                boolean cFlag = false;
                for (String s : enumValue) {
                    if (!s.equals(obj.toString())) continue;
                    cFlag = true;
                    break;
                }
                if (cFlag) continue;
                throw new XmlValidationException(ValidationConst.ErrorCode.wrongEnum.value, ResourceUtil.errorCodeMsg(null, ValidationConst.ErrorCode.wrongEnum.value, fildName));
            }
            if (BigDecimal.class != clazz) continue;
            try {
                new BigDecimal(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new XmlValidationException(ValidationConst.ErrorCode.numberFormat.value, ResourceUtil.errorCodeMsg(null, ValidationConst.ErrorCode.numberFormat.value, fildName));
            }
        }
    }

    public static boolean validateDate(String date, String pattren) {
        try {
            if (pattren.length() != date.length()) {
                return false;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattren);
            dateFormat.parse(date);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

