/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.servlets;

import com.allianz.cn.pc.common.model.bean.XmlResponse;
import com.allianz.cn.pc.utils.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public abstract class CommonServlet
extends HttpServlet {
    protected static final String CONTENT_TYPE = "text/html; charset=UTF-8";
    protected static final String ENCODING = "UTF-8";
    public static final String REMOTE_ADDRESS = "REMOTE_ADDRESS";
    public static final String REMOTE_USER = "REMOTE_USER";
    public static final String REQUEST_URL = "REQUEST_URL";
    public static final String REQUEST_PARAMETERS = "REQUEST_PARAMETERS";
    protected Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding(ENCODING);
        response.setContentType(CONTENT_TYPE);
        Document doc = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            String requestXml = IOUtils.toString((InputStream)request.getInputStream(), (String)ENCODING);
            this.logger.info((Object)("request xml :" + requestXml));
            SAXReader reader = new SAXReader();
            doc = reader.read((InputStream)new ByteArrayInputStream(requestXml.getBytes(ENCODING)));
            parameters.put(REMOTE_ADDRESS, request.getRemoteHost());
            parameters.put(REMOTE_USER, request.getRemoteUser());
            parameters.put(REQUEST_PARAMETERS, request.getParameterMap());
            parameters.put(REQUEST_URL, request.getRequestURL().toString());
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.logger.error((Object)e);
            this.handleResponse(response, "invalid request xml contenxt!");
            return;
        }
        Object responseResult = null;
        try {
            responseResult = this.doBusiness(doc, parameters);
        }
        catch (Exception e) {
            this.handleResponse(response, "process error!");
            e.printStackTrace();
            return;
        }
        this.handleResponse(response, responseResult);
    }

    protected abstract Object doBusiness(Document var1, Map<String, Object> var2) throws Exception;

    protected void handleResponse(HttpServletResponse response, Object msg) throws IOException {
        String contentType = CONTENT_TYPE;
        byte[] bytes = null;
        if (msg instanceof String) {
            bytes = ((String)msg).getBytes(ENCODING);
            this.logger.info((Object)("response string :" + msg));
        } else if (msg instanceof XmlResponse) {
            String xml = XmlUtil.toXml(msg, ENCODING);
            this.logger.info((Object)("response xml :" + xml));
            bytes = xml.getBytes(ENCODING);
        } else {
            contentType = "application/pdf";
            bytes = (byte[])msg;
        }
        response.setContentType(contentType);
        response.getOutputStream().write(bytes);
        response.getOutputStream().flush();
    }
}

