/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.utils;

import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.ReplacedAlias;
import com.allianz.cn.pc.utils.VEntry;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class BeanMap
extends AbstractMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 3561701476588049518L;
    static ThreadLocal<Map<Class, PropertyDescriptor[]>> getPropertyDescriptorsMapTL = new ThreadLocal();
    public static final Object[] NULL_ARGUMENTS = new Object[0];
    Object obj;
    Map<String, Map.Entry<String, Object>> entryMap;
    Set<Map.Entry<String, Object>> entrySet;
    boolean ignoreCase = false;

    public static PropertyDescriptor[] getPropertyDescriptors(Class c) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        Map<Class, PropertyDescriptor[]> propertyDescriptorsMap = getPropertyDescriptorsMapTL.get();
        if (propertyDescriptorsMap == null) {
            propertyDescriptorsMap = new HashMap<Class, PropertyDescriptor[]>();
            getPropertyDescriptorsMapTL.set(propertyDescriptorsMap);
        }
        if ((propertyDescriptors = propertyDescriptorsMap.get(c)) == null) {
            propertyDescriptors = Introspector.getBeanInfo(c).getPropertyDescriptors();
            propertyDescriptorsMap.put(c, propertyDescriptors);
        }
        return propertyDescriptors;
    }

    public BeanMap(Object obj) {
        this(obj, false);
    }

    public BeanMap(Object obj, boolean ignoreCase) {
        this.obj = obj;
        this.ignoreCase = ignoreCase;
        this.entryMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map.Entry<String, Object>> entryMap() {
        if (this.entryMap == null) {
            BeanMap beanMap = this;
            synchronized (beanMap) {
                this.entryMap = new HashMap<String, Map.Entry<String, Object>>(){

                    @Override
                    public Map.Entry<String, Object> get(Object key) {
                        key = BeanMap.this.wrapKey(key);
                        return (Map.Entry)super.get(key);
                    }

                    @Override
                    public boolean containsKey(Object key) {
                        key = BeanMap.this.wrapKey(key);
                        return super.containsKey(key);
                    }

                    @Override
                    public Map.Entry<String, Object> put(String key, Map.Entry<String, Object> entry) {
                        key = BeanMap.this.wrapKey(key);
                        return super.put(key, entry);
                    }
                };
                try {
                    if (this.obj == null) {
                        return this.entryMap;
                    }
                    for (final PropertyDescriptor propertyDescriptor : BeanMap.getPropertyDescriptors(this.obj.getClass())) {
                        ReplacedAlias alias;
                        if ("class".equals(propertyDescriptor.getName())) continue;
                        final String name = this.ignoreCase ? propertyDescriptor.getName().toLowerCase() : propertyDescriptor.getName();
                        Object annotation = this.getAnnotationValue(propertyDescriptor, ReplacedAlias.class);
                        final String aliasName = Beans.isNotEmpty(annotation) ? (Beans.isNotEmpty((alias = (ReplacedAlias)annotation).value()) ? alias.value() : name) : name;
                        if (this.entryMap.containsKey(name)) {
                            throw new RuntimeException(String.format("the property name %s repeated", name));
                        }
                        VEntry entry = new VEntry(){
                            Method readMethod;
                            Method writeMethod;
                            Class type;
                            Object annotation;

                            public Method getReadMethod() {
                                if (this.readMethod == null) {
                                    this.readMethod = propertyDescriptor.getReadMethod();
                                }
                                return this.readMethod;
                            }

                            public Method getWriteMethod() {
                                if (this.writeMethod == null) {
                                    this.writeMethod = propertyDescriptor.getWriteMethod();
                                }
                                return this.writeMethod;
                            }

                            @Override
                            public Object getKey() {
                                return name;
                            }

                            @Override
                            public Object getAliasKey() {
                                return aliasName;
                            }

                            @Override
                            public Object getValue() {
                                if (this.getReadMethod() == null) {
                                    return null;
                                }
                                try {
                                    this.getReadMethod().setAccessible(true);
                                    return this.getReadMethod().invoke(BeanMap.this.obj, NULL_ARGUMENTS);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }

                            @Override
                            public Object setValue(Object value) {
                                Object old = this.getValue();
                                if (this.getWriteMethod() == null) {
                                    throw new UnsupportedOperationException("the property:" + name + " is not exist a write method");
                                }
                                try {
                                    this.getWriteMethod().setAccessible(true);
                                    this.getWriteMethod().invoke(BeanMap.this.obj, value);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                                return old;
                            }

                            @Override
                            public Class getType() {
                                if (this.type == null) {
                                    this.type = propertyDescriptor.getPropertyType();
                                }
                                return this.type;
                            }

                            @Override
                            public boolean canRead() {
                                return this.getReadMethod() != null;
                            }

                            @Override
                            public boolean canWrite() {
                                return this.getWriteMethod() != null;
                            }

                            public Object getAnnotation(Class o) {
                                if (Beans.isEmpty(this.annotation)) {
                                    this.annotation = BeanMap.this.getAnnotationValue(propertyDescriptor, o);
                                }
                                return this.annotation;
                            }
                        };
                        this.entryMap.put(name, entry);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.entryMap = Collections.unmodifiableMap(this.entryMap);
            }
        }
        return this.entryMap;
    }

    public Object getAnnotationValue(PropertyDescriptor propertyDescriptor, Class o) {
        Object annotation = null;
        if (propertyDescriptor.getReadMethod() != null && propertyDescriptor.getReadMethod().isAnnotationPresent(o)) {
            annotation = propertyDescriptor.getReadMethod().getAnnotation(o);
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            BeanMap beanMap = this;
            synchronized (beanMap) {
                this.entrySet = new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        return BeanMap.this.entryMap.values().iterator();
                    }

                    @Override
                    public int size() {
                        return BeanMap.this.entryMap.size();
                    }
                };
                this.entrySet = Collections.unmodifiableSet(this.entrySet);
            }
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entryMap.containsKey(key);
    }

    private String wrapKey(Object key) {
        if (this.ignoreCase) {
            key = key == null ? null : key.toString().toLowerCase();
        }
        return key.toString();
    }

    @Override
    public Object put(String key, Object value) {
        Map.Entry<String, Object> entry = this.entryMap.get(key);
        if (entry == null) {
            throw new RuntimeException("this obj have no field name:" + key);
        }
        return entry.setValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.entryMap.keySet();
    }

    @Override
    public Object get(Object key) {
        Map.Entry<String, Object> entry = this.entryMap.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }
}

