/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.utils;

import com.allianz.cn.pc.utils.BeanMap;
import com.allianz.cn.pc.utils.VEntry;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;

public class Beans {
    private static final String PREFIX = "#{";
    private static final String SUFFIX = "}";

    public static void copy(Object t, Object s, boolean copyNull, boolean copyEmpty) {
        if (s == null || t == null) {
            return;
        }
        Map<String, Map.Entry<String, Object>> targetMap = new BeanMap(t).entryMap();
        Map<String, Map.Entry<String, Object>> sourceMap = new BeanMap(s).entryMap();
        for (String prop : targetMap.keySet()) {
            Object sourceObject;
            VEntry sourceEntry;
            VEntry targetEntry = (VEntry)targetMap.get(prop);
            if (Beans.isEmpty(targetEntry.getType()) || targetEntry.getType().isArray() || Collection.class.isAssignableFrom(targetEntry.getType()) || Map.class.isAssignableFrom(targetEntry.getType()) || (sourceEntry = (VEntry)sourceMap.get(prop)) == null || !targetEntry.getType().isAssignableFrom(sourceEntry.getType()) || (sourceObject = sourceEntry.getValue()) == null && !copyNull || !CharSequence.class.isAssignableFrom(targetEntry.getType()) && Beans.isEmpty(sourceObject) && !copyEmpty || !targetEntry.canWrite()) continue;
            targetEntry.setValue(sourceObject);
        }
    }

    public static void copy(Object t, Object s) {
        Beans.copy(t, s, false, false);
    }

    public static boolean isEmpty(Object sv) {
        if (sv == null) {
            return true;
        }
        if (sv instanceof byte[]) {
            return ((byte[])sv).length == 0;
        }
        if (sv.getClass().isArray()) {
            return ((Object[])sv).length == 0;
        }
        if (sv instanceof Collection) {
            return ((Collection)sv).isEmpty();
        }
        if (sv instanceof Map) {
            return ((Map)sv).isEmpty();
        }
        if (sv instanceof String) {
            return sv.toString().trim().equals("");
        }
        return sv.getClass().equals(Object.class);
    }

    public static boolean isNotEmpty(Object o) {
        return !Beans.isEmpty(o);
    }

    public static String firtCharToUpper(Object o) {
        if (Beans.isNotEmpty(o) && o instanceof String) {
            String first = o.toString().substring(0, 1);
            return o.toString().replaceFirst(first, first.toUpperCase());
        }
        return null;
    }

    public static Boolean isInRange(Integer start, Integer end, Integer value) {
        if (Beans.isEmpty(value) || Beans.isEmpty(start) || Beans.isEmpty(end)) {
            return false;
        }
        if (value.compareTo(start) != -1 && value.compareTo(end) == -1) {
            return true;
        }
        return false;
    }

    public static String getMD5(byte[] source) {
        String s = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            s = new String(str);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String replace(String text, Object obj) {
        String replaced = new String(text);
        if (text != null) {
            BeanMap m = new BeanMap(obj);
            for (Map.Entry<String, Object> entry : m.entrySet()) {
                VEntry e = (VEntry)entry;
                String key = PREFIX + e.getAliasKey().toString() + SUFFIX;
                if (e.getValue() == null) continue;
                replaced = replaced.replace(key, e.getValue().toString());
            }
        }
        return replaced;
    }
}

