/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.utils;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DataSourceClient {
    private static DataSource datasource = null;
    private static String datasourceName = null;
    private static DataSourceClient client = null;
    private static Logger log = Logger.getLogger(DataSourceClient.class);

    private DataSourceClient(String dataSourceConfigPath) {
        if (datasource == null) {
            try {
                Properties props = new Properties();
                props.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                Hashtable<String, String> ht = new Hashtable<String, String>();
                ht.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                datasourceName = DataSourceClient.getDatasourceName(dataSourceConfigPath);
                InitialContext ctx = new InitialContext(ht);
                datasource = (DataSource)ctx.lookup(datasourceName);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
            }
        }
    }

    private DataSourceClient(String ds, String flag) {
        if (datasource == null) {
            try {
                log.debug((Object)("look up " + ds));
                Properties props = new Properties();
                props.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                Hashtable<String, String> ht = new Hashtable<String, String>();
                ht.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                datasourceName = ds;
                InitialContext ctx = new InitialContext(ht);
                datasource = (DataSource)ctx.lookup(ds);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
            }
        }
    }

    public static synchronized DataSourceClient getInstance(String configFilePath) {
        if (client == null) {
            client = new DataSourceClient(configFilePath);
        }
        return client;
    }

    public static synchronized DataSourceClient getInstanceByName(String dsName) {
        if (client == null) {
            client = new DataSourceClient(dsName, null);
        }
        return client;
    }

    public DataSource getDataSource() {
        return datasource;
    }

    private static String getDatasourceName(String pathName) {
        Properties prop = new Properties();
        String dataSourceName = null;
        try {
            prop.load(DataSourceClient.class.getResourceAsStream("/config/" + pathName + ".properties"));
            dataSourceName = prop.getProperty("dataSourceName");
            System.out.println("dataSourceName is " + dataSourceName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dataSourceName;
    }
}

