/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.utils;

import com.allianz.cn.pc.utils.Beans;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DateUtil {
    private static ThreadLocal<Map<String, DateFormat>> dateFormatsTL = new ThreadLocal();
    private static final int[] dayArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final int HOUR = 10;
    public static final int DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static long millionSecondsOfDay = 86400000L;

    public static Long compareCurrentTime(Date start) {
        if (Beans.isEmpty(start)) {
            return null;
        }
        return new Date().getTime() - start.getTime();
    }

    public static DateFormat retrieveDateFormat(String format) {
        DateFormat dateFormat;
        Map<String, DateFormat> dateFormats = dateFormatsTL.get();
        if (dateFormats == null) {
            dateFormats = new HashMap<String, DateFormat>();
            dateFormatsTL.set(dateFormats);
        }
        if ((dateFormat = dateFormats.get(format = format.trim())) == null) {
            dateFormat = new SimpleDateFormat(format);
            dateFormats.put(format, dateFormat);
        }
        return dateFormat;
    }

    public static boolean validateDate(String date, String pattren) {
        DateFormat dateFormat = DateUtil.retrieveDateFormat(pattren);
        try {
            dateFormat.parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static String dateToStringWithFormat(Date date, String formate) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(formate);
            return formatter.format(date).trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static java.sql.Date convertUtilDateToSQLDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        java.sql.Date jd = new java.sql.Date(cl.getTimeInMillis());
        return jd;
    }

    public static Timestamp convertUtilDateToTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        Timestamp jd = new Timestamp(cl.getTimeInMillis());
        return jd;
    }

    public static Date convertSQLDateToUtilDate(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        Date jd = new Date(cl.getTimeInMillis());
        return jd;
    }

    public static Date stringToDate(String date) {
        if (date == null || "".equalsIgnoreCase(date)) {
            return null;
        }
        Calendar cd = Calendar.getInstance();
        StringTokenizer token = new StringTokenizer(date, "-/ :.");
        if (token.hasMoreTokens()) {
            cd.set(1, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(1, 1970);
        }
        if (token.hasMoreTokens()) {
            cd.set(2, Integer.parseInt(token.nextToken()) - 1);
        } else {
            cd.set(2, 0);
        }
        if (token.hasMoreTokens()) {
            cd.set(5, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(5, 1);
        }
        if (token.hasMoreTokens()) {
            cd.set(11, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(11, 0);
        }
        if (token.hasMoreTokens()) {
            cd.set(12, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(12, 0);
        }
        if (token.hasMoreTokens()) {
            cd.set(13, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(13, 0);
        }
        if (token.hasMoreTokens()) {
            cd.set(14, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(14, 0);
        }
        return cd.getTime();
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        return cl.get(1) + "-" + (cl.get(2) + 1) + "-" + cl.get(5);
    }

    public static String dateTo0String(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date).trim();
    }

    public static Date getFirstDateOfCurrentMonth() {
        Calendar cl = Calendar.getInstance();
        cl.set(5, 1);
        return cl.getTime();
    }

    public static Date getFirstDateOfMonth(String date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(DateUtil.stringToDate(date));
        cl.set(5, 1);
        return cl.getTime();
    }

    public static Date getLastDateOfMonth(String date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(DateUtil.stringToDate(date));
        int year = cl.get(1);
        int month = cl.get(2) + 1;
        int day = 0;
        if (month < 1 || month > 12) {
            return null;
        }
        day = month == 2 ? (DateUtil.isLeapYear(year) ? 29 : dayArray[month - 1]) : dayArray[month - 1];
        cl.set(5, day);
        return cl.getTime();
    }

    public static boolean isLeapYear(int year) {
        if (year % 400 == 0) {
            return true;
        }
        if (year % 4 == 0) {
            return year % 100 != 0;
        }
        return false;
    }

    public static Date getDateTimeBeforeNow(int type, int value) {
        return DateUtil.getDateTimeBefore(new Date(), type, value);
    }

    public static Date getDateTimeBefore(Date date, int type, int value) {
        long time = date.getTime() / 1000L;
        switch (type) {
            case 11: {
                time -= (long)(86400 * value);
                break;
            }
            case 10: {
                time -= (long)(3600 * value);
                break;
            }
            case 12: {
                time -= (long)(60 * value);
                break;
            }
            case 13: {
                time -= (long)value;
                break;
            }
        }
        return new Date(time * 1000L);
    }

    public static Date getDateTimeAfterNow(int type, long value) {
        return DateUtil.getDateTimeAfter(new Date(), type, value);
    }

    public static Date getDateTimeAfter(Date date, int type, long value) {
        long nextTime = date.getTime() / 1000L;
        switch (type) {
            case 11: {
                nextTime += 86400L * value;
                break;
            }
            case 10: {
                nextTime += 3600L * value;
                break;
            }
            case 12: {
                nextTime += 60L * value;
                break;
            }
            case 13: {
                nextTime += value;
                break;
            }
        }
        return new Date(nextTime * 1000L);
    }

    public static String getnextDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        Date newDate = c.getTime();
        return DateUtil.dateToString(newDate);
    }

    public static Date getNextDate(String date) {
        Calendar cd = Calendar.getInstance();
        StringTokenizer token = new StringTokenizer(date, "-/ :.");
        if (token.hasMoreTokens()) {
            cd.set(1, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(1, 1970);
        }
        if (token.hasMoreTokens()) {
            cd.set(2, Integer.parseInt(token.nextToken()) - 1);
        } else {
            cd.set(2, 0);
        }
        if (token.hasMoreTokens()) {
            cd.set(5, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(5, 1);
        }
        if (token.hasMoreTokens()) {
            cd.set(11, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(11, 0);
        }
        if (token.hasMoreTokens()) {
            cd.set(12, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(12, 0);
        }
        if (token.hasMoreTokens()) {
            cd.set(13, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(13, 0);
        }
        if (token.hasMoreTokens()) {
            cd.set(14, Integer.parseInt(token.nextToken()));
        } else {
            cd.set(14, 0);
        }
        long nextTime = cd.getTimeInMillis() + 86400000L;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return new Date(nextTime);
    }

    public static boolean isToday(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(new Date());
        Calendar day = Calendar.getInstance();
        day.setTime(date);
        return today.get(1) == day.get(1) && today.get(2) == day.get(2) && today.get(5) == day.get(5);
    }

    public static String formatTimeStamp(Date date) {
        return timeStampFormat.format(date);
    }

    public static Date StringToDate(String sDate, int nFormat) {
        Date resDate = new Date();
        try {
            if (sDate == null || sDate.equals("")) {
                return null;
            }
            String sFormat = "";
            sFormat = nFormat == 1 ? "yyyy-MM-dd" : (nFormat == 2 ? "yyyy-MM-dd HH:mm:ss" : (nFormat == 3 ? "yyyy-MM" : (nFormat == 4 ? "yyyy-MM-dd HH:mm" : (nFormat == 5 ? "yyyyMMdd HH:mm" : "yyyy-MM-dd"))));
            SimpleDateFormat simDateFormat = new SimpleDateFormat(sFormat);
            resDate = simDateFormat.parse(sDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return resDate;
    }

    public static String DateToString(Date dDate, int nFormat) {
        String resString = "";
        String sDay = "";
        try {
            String sFormat = "";
            sFormat = nFormat == 1 ? "yyyy-MM-dd" : (nFormat == 2 ? "yyyy-MM-dd HH:mm:ss" : (nFormat == 3 ? "yyyy-MM-dd EEE" : (nFormat == 4 ? "ddMMyyyy" : (nFormat == 5 ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd"))));
            SimpleDateFormat simDateFormat = new SimpleDateFormat(sFormat);
            resString = simDateFormat.format(dDate);
        }
        catch (Exception e) {
            return resString;
        }
        return resString;
    }

    public static Date parseTimeStamp(String date) throws Exception {
        try {
            return timeStampFormat.parse(date);
        }
        catch (ParseException e) {
            throw new Exception("invalid date format!");
        }
    }

    public static int getDay(Date date1, Date date2) {
        Long d2 = date2.getTime();
        Long d1 = date1.getTime();
        return (int)((d2 - d1) / millionSecondsOfDay);
    }

    public static Date addDay(Date date, int days) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        ((Calendar)c).add(5, days);
        return c.getTime();
    }

    public static Date parse(String date, String formater) {
        SimpleDateFormat sdf = new SimpleDateFormat(formater);
        Date result = null;
        try {
            result = sdf.parse(date.trim());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date parse(String date) {
        return DateUtil.parse(date, "yyyy-MM-dd HH:mm:ss.0");
    }

    public static int getWeekOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7) - 1 == 0 ? 7 : calendar.get(7) - 1;
    }

    public static String dateToString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date).trim();
    }

    public static int getDaysOfNextYear(Date startDate) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendarNextYear = Calendar.getInstance();
        calendar.setTime(startDate);
        calendarNextYear.setTime(startDate);
        int nowYear = calendar.get(1);
        calendarNextYear.set(1, nowYear + 1);
        return DateUtil.getDay(calendar.getTime(), calendarNextYear.getTime());
    }

    public static Date getTimeOfNextYear(Date startDate) {
        return DateUtil.getTimeOfYear(startDate, 1);
    }

    public static Date getTimeOfYear(Date startDate, int year) {
        Calendar caltYear = Calendar.getInstance();
        caltYear.setTime(startDate);
        caltYear.add(1, year);
        return caltYear.getTime();
    }

    public static Date getTimeOfMonth(Date startDate, int month) {
        Calendar calDateTime = Calendar.getInstance();
        calDateTime.setTime(startDate);
        calDateTime.add(2, month);
        return calDateTime.getTime();
    }

    public static Date string2shortdate(String dateStr) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPersonTypeByBirthdate(Date birthDate) {
        Date adultAge = DateUtil.getTimeOfYear(new Date(), -18);
        Date elderAge = DateUtil.getTimeOfYear(new Date(), -65);
        if (elderAge.after(birthDate)) {
            return "3";
        }
        if (adultAge.before(birthDate)) {
            return "2";
        }
        return "1";
    }
}

