/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.utils;

import com.allianz.cn.pc.utils.Beans;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceUtil {
    private static final String PROP_FILE = "com.allianz.cn.pc.common.res.Bundle";
    private static final String DEFAULT_LOCALE = "zh_CN";

    public static String getProperty(String propertyKey) {
        ResourceBundle bundle = ResourceUtil.getBundle();
        return bundle.getString(propertyKey);
    }

    public static String getPropertyWithParams(String propertyKey, Object ... args) {
        ResourceBundle bundle = ResourceUtil.getBundle();
        String mssage = bundle.getString(propertyKey);
        return String.format(mssage, args);
    }

    public static String errorCodeMsg(String locale, String key, Object ... args) {
        String errorKey = "error.msg." + key;
        if (Beans.isEmpty(locale)) {
            locale = DEFAULT_LOCALE;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(PROP_FILE, new Locale(locale.split("_")[0], locale.split("_")[1]));
        String mssage = bundle.getString(errorKey);
        return String.format(mssage, args);
    }

    public static String errorCodeMsg(String key, Object ... args) {
        String errorKey = "error.msg." + key;
        ResourceBundle bundle = ResourceUtil.getBundle();
        String mssage = bundle.getString(errorKey);
        return String.format(mssage, args);
    }

    public static String getProperty(String propertyKey, String locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(PROP_FILE, new Locale(locale.split("_")[0], locale.split("_")[1]));
        return bundle.getString(propertyKey);
    }

    public static String getLocale() {
        return DEFAULT_LOCALE;
    }

    public static ResourceBundle getBundle() {
        String locale = ResourceUtil.getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(PROP_FILE, new Locale(locale.split("_")[0], locale.split("_")[1]));
        return bundle;
    }
}

