/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class UUID16Generator
implements Serializable {
    private static final long serialVersionUID = -2669965391494374578L;
    private static int UUID_HOST_LOCK_PORT = 5504;
    private static ServerSocket lockSocket;
    private static long timeStamp;
    private static long adapterAddress;
    private static int instanceCounter;
    private static final char[] hexDigits;
    private long high;
    private long low;
    private transient String str36 = null;

    private static synchronized void acquireHostLock() throws Exception {
        String portProperty = null;
        try {
            portProperty = System.getProperty("bluewater.uuid.hostLockPort");
        }
        catch (SecurityException securityexception) {
            // empty catch block
        }
        if (portProperty != null) {
            try {
                UUID_HOST_LOCK_PORT = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException numberformatexception) {
                // empty catch block
            }
        }
        int numberOfRetrys = 0;
        while (lockSocket == null) {
            try {
                lockSocket = new ServerSocket(UUID_HOST_LOCK_PORT);
                return;
            }
            catch (BindException bindexception) {
            }
            catch (IOException e2) {
                throw new Exception("Unique identifier unexpected failure");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (numberOfRetrys == 1200) {
                throw new Exception("Unique identifier lock failure");
            }
            ++numberOfRetrys;
        }
    }

    public static synchronized UUID16Generator create() {
        try {
            int count;
            if (timeStamp == 0L) {
                UUID16Generator.setTimeStamp();
            }
            if (adapterAddress == 0L) {
                UUID16Generator.setAdapterAddress();
            }
            UUID16Generator uuid = new UUID16Generator();
            long midTime = timeStamp >> 32 & 0xFFFFFFFFL;
            uuid.high = timeStamp << 32 | midTime << 16 & 0xFFFF0000L | 0x1000L | timeStamp >> 48 & 0xFFFL;
            if ((count = instanceCounter++) == 0x1FFFFFFF) {
                instanceCounter = 0;
                UUID16Generator.setTimeStamp();
            }
            uuid.low = ((long)count & 0x1FFFFFFFL) << 32 | 0xE000000000000000L | adapterAddress;
            return uuid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void letClockTick(long curTime) throws Exception {
        int timeoutCounter = 0;
        long sleepTime = 1L;
        long newTime = System.currentTimeMillis();
        while (newTime == curTime) {
            ++timeoutCounter;
            sleepTime *= 2L;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedexception) {
                // empty catch block
            }
            if (sleepTime > 60000L) {
                throw new Exception("Unique identifier unexpected failure");
            }
            newTime = System.currentTimeMillis();
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            System.out.println(UUID16Generator.create());
        }
    }

    public static UUID16Generator read(DataInput in) throws IOException {
        long high = in.readLong();
        long low = in.readLong();
        return new UUID16Generator(high, low);
    }

    public static UUID16Generator read(String id) throws Exception {
        String part = id.substring(0, 8);
        long high = 0L;
        high = Long.parseLong(part, 16) << 32;
        part = id.substring(9, 13);
        high |= Long.parseLong(part, 16) << 16;
        part = id.substring(14, 18);
        high |= Long.parseLong(part, 16);
        long low = 0L;
        part = id.substring(19, 23);
        low = Long.parseLong(part, 16) << 48;
        part = id.substring(24, 36);
        UUID16Generator uuid = new UUID16Generator(high, low |= Long.parseLong(part, 16));
        return uuid;
    }

    private static void releaseHostLock() {
        if (lockSocket != null) {
            try {
                lockSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lockSocket = null;
        }
    }

    private static void setAdapterAddress() throws Exception {
        try {
            byte[] addr = InetAddress.getLocalHost().getAddress();
            int raw = addr[3] & 0xFF | addr[2] << 8 & 0xFF00 | addr[1] << 16 & 0xFF0000 | addr[0] << 24 & 0xFF000000;
            adapterAddress = (long)raw & 0xFFFFFFFFL;
        }
        catch (UnknownHostException e) {
            throw new Exception("Unexpected failure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTimeStamp() throws Exception {
        UUID16Generator.acquireHostLock();
        try {
            long newTime = System.currentTimeMillis();
            if (timeStamp != 0L) {
                if (newTime < timeStamp) {
                    throw new Exception("Unique identifier clock failure");
                }
                if (newTime == timeStamp) {
                    UUID16Generator.letClockTick(newTime);
                    newTime = System.currentTimeMillis();
                }
            }
            timeStamp = newTime;
        }
        finally {
            UUID16Generator.releaseHostLock();
        }
    }

    private static String toHexString(long x, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = hexDigits[(int)(x & 0xFL)];
            x >>>= 4;
        }
        return new String(buf);
    }

    private UUID16Generator() {
    }

    private UUID16Generator(long high, long low) {
        this.high = high;
        this.low = low;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof UUID16Generator) {
            return this.high == ((UUID16Generator)obj).high && this.low == ((UUID16Generator)obj).low;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.low << 24) & 0xFF000000 | (int)(this.high >> 20) & 0xFFF000 | (int)(this.low >> 32) & 0xFFF;
    }

    public byte[] toByteArray() {
        byte[] array = new byte[16];
        this.toBytes(this.high, array, 0);
        this.toBytes(this.low, array, 8);
        return array;
    }

    private void toBytes(long x, byte[] array, int startPos) {
        int bytePos = 8;
        while (--bytePos >= 0) {
            array[startPos + bytePos] = (byte)(x & 0xFFL);
            x >>>= 8;
        }
    }

    public String toString() {
        if (this.str36 != null) {
            return this.str36;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(UUID16Generator.toHexString(this.high >>> 32, 8));
        buf.append(UUID16Generator.toHexString(this.low >>> 24, 8));
        this.str36 = buf.toString();
        return this.str36;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.high);
        out.writeLong(this.low);
    }

    static {
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

