/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.utils;

import java.net.InetAddress;

public class UUIDHexGenerator {
    private String sep = "";
    private static int IP;
    private static short counter;
    private static final int JVM;
    private static UUIDHexGenerator uuidgen;

    public static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    public static UUIDHexGenerator getInstance() {
        return uuidgen;
    }

    protected String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuffer buf = new StringBuffer("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    protected int getJVM() {
        return JVM;
    }

    protected synchronized short getCount() {
        if (counter < 0) {
            counter = 0;
        }
        short s = counter;
        counter = (short)(s + 1);
        return s;
    }

    protected int getIP() {
        return IP;
    }

    protected short getHiTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    protected int getLoTime() {
        return (int)System.currentTimeMillis();
    }

    public String generate() {
        return new StringBuffer(32).append(this.format(this.getIP())).append(this.sep).append(this.format(this.getJVM())).append(this.sep).append(this.format(this.getHiTime())).append(this.sep).append(this.format(this.getLoTime())).append(this.sep).append(this.format(this.getCount())).toString();
    }

    static {
        int ipadd;
        counter = 0;
        JVM = (int)(System.currentTimeMillis() >>> 8);
        uuidgen = new UUIDHexGenerator();
        try {
            ipadd = UUIDHexGenerator.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            ipadd = 0;
        }
        IP = ipadd;
    }
}

