/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.test;

import com.allianz.cn.pc.utils.DesEncodeUtil;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Metadata {
    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(DesEncodeUtil.get32UUID());
        }
    }

    void readAndDisplayMetadata(String fileName) {
        try {
            File file = new File(fileName);
            ImageInputStream iis = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(iis, true);
                IIOMetadata metadata = reader.getImageMetadata(0);
                String[] names = metadata.getMetadataFormatNames();
                int length = names.length;
                for (int i = 0; i < length; ++i) {
                    System.out.println("Format name: " + names[i]);
                    this.displayMetadata(metadata.getAsTree(names[i]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void displayMetadata(Node root) {
        this.displayMetadata(root, 0);
    }

    void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("    ");
        }
    }

    void displayMetadata(Node node, int level) {
        Node child;
        this.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) == null) {
            System.out.println("/>");
            return;
        }
        System.out.println(">");
        while (child != null) {
            this.displayMetadata(child, level + 1);
            child = child.getNextSibling();
        }
        this.indent(level);
        System.out.println("</" + node.getNodeName() + ">");
    }
}

