/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms;

import com.allianz.cn.pc.services.sms.SMSContent;
import com.allianz.cn.pc.services.sms.SMSFactory;
import com.allianz.cn.pc.services.sms.SMSService;
import com.allianz.cn.pc.services.sms.beans.SmsInfo;
import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractSMSService
implements SMSService {
    protected String currentAppName;
    protected String currentSendTableName;
    protected String currentSMSPrefix;

    protected AbstractSMSService(Map<String, Object> configMap) {
        this.currentAppName = (String)configMap.get("currentAppName");
        this.currentSendTableName = (String)configMap.get("sms.send.tablename");
        String prefix = this.getProviderPrefix();
        if (!Beans.isEmpty((Object)prefix)) {
            this.currentSMSPrefix = (String)configMap.get(prefix + ".sms.prefix");
            if (Beans.isEmpty((Object)this.currentSMSPrefix)) {
                this.currentSMSPrefix = "";
            }
        }
    }

    protected abstract String getProviderPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSmsRecord(SmsInfo smsInfo) {
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        try {
            conn = smsDS.getConnection();
            prepStmt = conn.prepareStatement("insert into " + this.currentSendTableName + "(ID,CONTENT,SEND_MOBILE,PROVIDER,APP_NAME,STATUS,value1,value2,remark,flag,SENDTIME) " + "values(prl_smsgw_send_seq.nextval,?,?,?,?,?,?,?,?,?,?)");
            prepStmt.setString(1, smsInfo.getContent());
            prepStmt.setString(2, smsInfo.getSendMobile());
            prepStmt.setString(3, smsInfo.getProvider());
            prepStmt.setString(4, SMSFactory.getCurrentAppName());
            prepStmt.setString(5, smsInfo.getStatus());
            prepStmt.setString(6, smsInfo.getValue1());
            prepStmt.setString(7, smsInfo.getValue2());
            prepStmt.setString(8, smsInfo.getRemark());
            prepStmt.setString(9, smsInfo.getFlag());
            if (SMSContent.SendStatus.sended.value.equals(smsInfo.getStatus())) {
                prepStmt.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
            } else {
                prepStmt.setTimestamp(10, null);
            }
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }
}

