/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms;

import com.allianz.cn.pc.services.sms.SMSService;
import com.allianz.cn.pc.services.sms.yimei.YiMeiSMSServiceImpl;
import com.allianz.cn.pc.services.smsmailgw.Constants;
import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class SMSFactory {
    private static Map<String, Object> configMap = new HashMap<String, Object>();
    private static final String REFRESH_INTERVAL_TIME = "refresh.interval.time";
    private static final String LAST_REFRESH_TIME = "last.refresh.time";
    public static final String SMS_PROVIDER_KEY_NAME = "sms.provider";
    public static final String COMMON_PROVIDER_KEY = "common.provider.key";
    public static final String SPECIAL_PROVIDER_KEY = "special.provider.key";
    public static final String SMS_PROVIDER_YIMEI = "yimei";
    public static final String CURRENT_APP_NAME = "currentAppName";
    public static final String CURRENT_SEND_TABLE_NAME = "sms.send.tablename";
    public static final String SMS_FLAG = "sms.flag";
    private static Logger logger = Logger.getLogger(SMSFactory.class);

    public static SMSService getSMSInstance() {
        logger.debug((Object)"start to getInstance");
        return SMSFactory.getSMSInstance(null);
    }

    public static synchronized SMSService getSMSInstance(String appName) {
        boolean isNeedRefresh = false;
        if (configMap.size() == 0 || SMSFactory.isNeedRefresh()) {
            logger.debug((Object)"start to init");
            logger.debug((Object)"Start to refresh SMS config");
            if (configMap.size() == 0) {
                configMap.put(LAST_REFRESH_TIME, new Date());
            }
            SMSFactory.initConfigValue(appName);
            isNeedRefresh = true;
            logger.debug((Object)"End refresh SMS config");
        }
        if (configMap.get(SPECIAL_PROVIDER_KEY) != null) {
            if (SMS_PROVIDER_YIMEI.equalsIgnoreCase((String)configMap.get(SPECIAL_PROVIDER_KEY))) {
                return YiMeiSMSServiceImpl.getInstance(configMap, isNeedRefresh);
            }
            return YiMeiSMSServiceImpl.getInstance(configMap, isNeedRefresh);
        }
        return YiMeiSMSServiceImpl.getInstance(configMap, isNeedRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConfigValue(String appName) {
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        PreparedStatement prepStmt = null;
        Statement prepStmt2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        configMap.put(CURRENT_APP_NAME, appName);
        try {
            conn = smsDS.getConnection();
            prepStmt = conn.prepareStatement("select * from prpl_app_parameter where app_name=? and status='1' ");
            prepStmt.setString(1, "SMSMAILGT");
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                if (SMS_PROVIDER_KEY_NAME.equalsIgnoreCase(rs.getString("KEY"))) {
                    configMap.put(COMMON_PROVIDER_KEY, rs.getString("VALUE"));
                    logger.debug((Object)("common sms provider is " + configMap.get(COMMON_PROVIDER_KEY)));
                    continue;
                }
                configMap.put(rs.getString("KEY"), rs.getString("VALUE"));
            }
            if (!Beans.isEmpty((Object)appName)) {
                prepStmt2 = conn.prepareStatement("select * from prpl_app_parameter where app_name=? and status='1' and lower(key) like 'sms%' ");
                prepStmt2.setString(1, appName);
                rs2 = prepStmt2.executeQuery();
                while (rs2.next()) {
                    if (Beans.isEmpty((Object)rs2.getString("value"))) continue;
                    configMap.put(rs2.getString("key"), rs2.getString("value"));
                    logger.debug((Object)("special config is " + rs2.getString("key") + "," + rs2.getString("value")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (rs2 != null) {
                    rs2.close();
                }
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (prepStmt2 != null) {
                    prepStmt2.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static boolean isNeedRefresh() {
        boolean result = false;
        if (configMap.get(REFRESH_INTERVAL_TIME) != null) {
            if (configMap.get(LAST_REFRESH_TIME) == null) {
                configMap.put(LAST_REFRESH_TIME, new Date());
            } else {
                int intervalTime = Integer.valueOf(configMap.get(REFRESH_INTERVAL_TIME).toString());
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)configMap.get(LAST_REFRESH_TIME));
                cal.add(12, intervalTime);
                Date currentDate = new Date();
                if (currentDate.compareTo(cal.getTime()) > 0) {
                    logger.debug((Object)("update last refresh time to " + currentDate + ",intervalTime is " + intervalTime));
                    configMap.put(LAST_REFRESH_TIME, currentDate);
                    return true;
                }
            }
        }
        return result;
    }

    public static String getCurrentAppName() {
        return (String)configMap.get(CURRENT_APP_NAME);
    }

    public static boolean isAllowSendSms() {
        String sendMsgFlg = (String)configMap.get(SMS_FLAG);
        return Beans.isEmpty((Object)sendMsgFlg) || !Constants.SMSSendSwitch.Off.value.equals(sendMsgFlg);
    }
}

